<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 *
 */
Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:AuditCategory' => '审计类别',
	'Class:AuditCategory+' => '审计类别规定了需要被审计的对象的范围.
其组合了用于此范围内对象的所有审计规则',
	'Class:AuditCategory/Attribute:name' => '类别',
	'Class:AuditCategory/Attribute:name+' => '类别简称',
	'Class:AuditCategory/Attribute:description' => '审计类别描述',
	'Class:AuditCategory/Attribute:description+' => '此审计类别的详细描述',
	'Class:AuditCategory/Attribute:definition_set' => '定义',
	'Class:AuditCategory/Attribute:definition_set+' => '定义用于审计的对象的OQL表达式',
	'Class:AuditCategory/Attribute:rules_list' => '审计规则',
	'Class:AuditCategory/Attribute:rules_list+' => '此类别的审计规则',
	'Class:AuditCategory/Attribute:ok_error_tolerance' => '报警阈值 (正常)',
	'Class:AuditCategory/Attribute:ok_error_tolerance+' => '结果仍然显示为正常 (绿色) 的可允许的最大无效对象比例',
	'Class:AuditCategory/Attribute:warning_error_tolerance' => '错误阈值 (警告)',
	'Class:AuditCategory/Attribute:warning_error_tolerance+' => '结果仍然显示为警告 (橙色) 的可允许的最大无效对象比例',
	'Class:AuditCategory/Attribute:domains_list' => '审计域',
	'Class:AuditCategory/Attribute:domains_list+' => '关联此类别的审计域列表',
));

//
// Class: AuditRule
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:AuditRule' => '审计规则',
	'Class:AuditRule+' => '一条审计规则对应审计类别中的一项检查.
其应用于审计规则定义的对象范围',
	'Class:AuditRule/Attribute:name' => '名称',
	'Class:AuditRule/Attribute:name+' => '规则名称',
	'Class:AuditRule/Attribute:description' => '描述',
	'Class:AuditRule/Attribute:description+' => '检查什么? 如何修复? 谁去做? ...',
	'Class:AuditRule/Attribute:query' => '要运行的查询',
	'Class:AuditRule/Attribute:query+' => '要运行的OQL表达式',
	'Class:AuditRule/Attribute:valid_flag' => '是否有效?',
	'Class:AuditRule/Attribute:valid_flag+' => '若规则返回有效对象则True, 否则False',
	'Class:AuditRule/Attribute:valid_flag/Value:true' => 'Valid objects~~',
	'Class:AuditRule/Attribute:valid_flag/Value:true+' => 'Then objects in error are those part of the scope and not in the list of valid objects~~',
	'Class:AuditRule/Attribute:valid_flag/Value:false' => 'Invalid objects~~',
	'Class:AuditRule/Attribute:valid_flag/Value:false+' => 'Then objects in error are the invalid objects which are part of the scope~~',
	'Class:AuditRule/Attribute:category_id' => '类别',
	'Class:AuditRule/Attribute:category_id+' => '该规则对应的类别',
	'Class:AuditRule/Attribute:category_name' => '类别',
	'Class:AuditRule/Attribute:category_name+' => '该规则对应的类名称',
));

//
// Class: AuditDomain
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:AuditDomain' => '审计域',
	'Class:AuditDomain+' => '审计域用于分组审计规则.
审计域通常对应负责检查和修复错误的人',
	'Class:AuditDomain/Attribute:name' => '名称',
	'Class:AuditDomain/Attribute:name+' => '用于细分负责修复错误或只对审计感兴趣的人员',
	'Class:AuditDomain/Attribute:description' => '描述',
	'Class:AuditDomain/Attribute:description+' => '',
	'Class:AuditDomain/Attribute:icon' => '图标',
	'Class:AuditDomain/Attribute:icon+' => '',
	'Class:AuditDomain/Attribute:categories_list' => '类别',
	'Class:AuditDomain/Attribute:categories_list+' => '关联的审计类别',
));

//
// Class: lnkAuditCategoryToAuditDomain
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:lnkAuditCategoryToAuditDomain' => '关联审计类别/审计域',
	'Class:lnkAuditCategoryToAuditDomain+' => '',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id' => '类别',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id+' => '审计类别',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name' => '名称',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name+' => '审计类别名称',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id' => '审计域',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id+' => '审计域',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name' => '名称',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name+' => '审计域名称',
));

//
// Class: QueryOQL
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:Query' => '查询',
	'Class:Query+' => '查询是一种动态的数据集',
	'Class:Query/Attribute:name' => '名称',
	'Class:Query/Attribute:name+' => '查询的名称',
	'Class:Query/Attribute:description' => '描述',
	'Class:Query/Attribute:description+' => '请描述此查询 (目的, 用法等等.)',
	'Class:Query/Attribute:is_template' => 'OQL模板',
	'Class:Query/Attribute:is_template+' => '可用于通知中的收件人OQL',
	'Class:Query/Attribute:is_template/Value:yes' => '是',
	'Class:Query/Attribute:is_template/Value:no' => '否',
	'Class:Query/Attribute:export_count' => '导出计数',
	'Class:Query/Attribute:export_count+' => '反应此查询执行的次数',
	'Class:Query/Attribute:export_last_date' => '最近导出',
	'Class:Query/Attribute:export_last_date+' => '最近一次导出执行的日期和时间',
	'Class:Query/Attribute:export_last_user_id' => '用户',
	'Class:Query/Attribute:export_last_user_id+' => '执行最近一次导出的用户',
	'Class:Query/Attribute:export_last_user_contact' => '联系人',
	'Class:Query/Attribute:export_last_user_contact+' => '执行最近一次导出的联系人',
	'Query:baseinfo' => '基本信息',
	'Query:exportInfo' => '导出信息',
	'Class:QueryOQL/Attribute:fields' => '字段',
	'Class:QueryOQL/Attribute:fields+' => '逗号分隔的待导出字段 (或者alias.attribute)',
	'Class:QueryOQL' => 'OQL查询',
	'Class:QueryOQL+' => '一种基于对象查询的语言',
	'Class:QueryOQL/Attribute:oql' => '表达式',
	'Class:QueryOQL/Attribute:oql+' => 'OQL表达式',
));

//////////////////////////////////////////////////////////////////////
// Classes in 'addon/userrights'
//////////////////////////////////////////////////////////////////////
//

//
// Class: User
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:User' => '用户',
	'Class:User+' => '用户登录名',
	'Class:User/Attribute:finalclass' => '账号类型',
	'Class:User/Attribute:finalclass+' => '根本属性的名称',
	'Class:User/Attribute:contactid' => '人员',
	'Class:User/Attribute:contactid+' => '来自业务数据的人员明细信息',
	'Class:User/Attribute:org_id' => '组织',
	'Class:User/Attribute:org_id+' => '用户所属的组织',
	'Class:User/Attribute:last_name' => '姓',
	'Class:User/Attribute:last_name+' => '对应联系人的姓氏',
	'Class:User/Attribute:first_name' => '名',
	'Class:User/Attribute:first_name+' => '对应联系人的名字',
	'Class:User/Attribute:email' => '邮箱',
	'Class:User/Attribute:email+' => '对应联系人的邮箱',
	'Class:User/Attribute:login' => '登录名',
	'Class:User/Attribute:login+' => '用户标识字符串',
	'Class:User/Attribute:language' => '语言',
	'Class:User/Attribute:language+' => '用户语言',
	'Class:User/Attribute:language/Value:EN US' => '英语',
	'Class:User/Attribute:language/Value:EN US+' => '英语 (U.S.)',
	'Class:User/Attribute:language/Value:FR FR' => '法语',
	'Class:User/Attribute:language/Value:FR FR+' => '法语 (France)',
	'Class:User/Attribute:profile_list' => '角色',
	'Class:User/Attribute:profile_list+' => '授予此用户的角色',
	'Class:User/Attribute:allowed_org_list' => '可访问的组织',
	'Class:User/Attribute:allowed_org_list+' => '目标用户可以看到以下组织的数据. 如果没有指定,则无限制.',
	'Class:User/Attribute:status' => '状态',
	'Class:User/Attribute:status+' => '账号是否启用.',
	'Class:User/Attribute:status/Value:enabled' => '启用',
	'Class:User/Attribute:status/Value:disabled' => '停用',
	'Class:User/Error:LoginMustBeUnique' => '登录名必须唯一 - "%1s" 已经被使用.',
	'Class:User/Error:AtLeastOneProfileIsNeeded' => '必须指定至少一个角色给此用户.',
	'Class:User/Error:ProfileNotAllowed' => '无法添加角色 "%1$s" 因为这将导致禁止访问后台',
	'Class:User/Error:StatusChangeIsNotAllowed' => '不允许更改您自己用户的状态',
	'Class:User/Error:AllowedOrgsMustContainUserOrg' => '允许访问组织必须包含用户组织',
	'Class:User/Error:CurrentProfilesHaveInsufficientRights' => '当前指定的角色列表没有提供足够的访问权限 (用户将无法被修改)',
	'Class:User/Error:PortalPowerUserHasInsufficientRights' => 'The Portal power user profile does not give sufficient access rights (another profile must be added)~~',
	'Class:User/Error:AtLeastOneOrganizationIsNeeded' => '必须为此用户指定一个组织.',
	'Class:User/Error:OrganizationNotAllowed' => '此组织不被允许.',
	'Class:User/Error:UserOrganizationNotAllowed' => '此用户不属于那个组织.',
	'Class:User/Error:PersonIsMandatory' => '联系人必填.',
	'Class:User/Warning:NoOrganizationMeansFullAccess' => 'No "Allowed Organizations" defined for this user, this means they have access to all organizations~~',
	'Class:User/Warning:NoContactHasImpact' => 'Cautious: there is no Person defined on this User, this prevents access to portals, news notifications and other side effects in back-office~~',
	'Class:UserInternal' => '内部用户',
	'Class:UserInternal+' => ITOP_APPLICATION_SHORT.'内部定义的用户',
));

//
// Class: URP_Profiles
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_Profiles' => '角色',
	'Class:URP_Profiles+' => '用户角色',
	'Class:URP_Profiles/Attribute:name' => '名称',
	'Class:URP_Profiles/Attribute:name+' => '标签',
	'Class:URP_Profiles/Attribute:description' => '描述',
	'Class:URP_Profiles/Attribute:description+' => '单行描述',
	'Class:URP_Profiles/Attribute:user_list' => '用户',
	'Class:URP_Profiles/Attribute:user_list+' => '拥有此角色的用户',
));

//
// Class: URP_Dimensions
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_Dimensions' => '维度',
	'Class:URP_Dimensions+' => '应用维度 (定义纵深)',
	'Class:URP_Dimensions/Attribute:name' => '名称',
	'Class:URP_Dimensions/Attribute:name+' => '标签',
	'Class:URP_Dimensions/Attribute:description' => '描述',
	'Class:URP_Dimensions/Attribute:description+' => '单行描述',
	'Class:URP_Dimensions/Attribute:type' => '类型',
	'Class:URP_Dimensions/Attribute:type+' => '类型名称或数据类型 (投影单位)',
));

//
// Class: URP_UserProfile
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_UserProfile' => '角色目标用户',
	'Class:URP_UserProfile+' => '用户的角色',
	'Class:URP_UserProfile/Name' => '关联 %1$s 和 %2$s',
	'Class:URP_UserProfile/Attribute:userid' => '用户',
	'Class:URP_UserProfile/Attribute:userid+' => '用户账号',
	'Class:URP_UserProfile/Attribute:userlogin' => '登录名',
	'Class:URP_UserProfile/Attribute:userlogin+' => '用户的登录名',
	'Class:URP_UserProfile/Attribute:profileid' => '角色',
	'Class:URP_UserProfile/Attribute:profileid+' => '使用角色',
	'Class:URP_UserProfile/Attribute:profile' => '角色',
	'Class:URP_UserProfile/Attribute:profile+' => '角色名称',
	'Class:URP_UserProfile/Attribute:reason' => '原因',
	'Class:URP_UserProfile/Attribute:reason+' => '解释为什么此用户需要拥有此角色',
));

//
// Class: URP_UserOrg
//


Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_UserOrg' => '用户组织',
	'Class:URP_UserOrg+' => '可以访问的组织',
	'Class:URP_UserOrg/Name' => '关联 %1$s 和 %2$s',
	'Class:URP_UserOrg/Attribute:userid' => '用户',
	'Class:URP_UserOrg/Attribute:userid+' => '用户账号',
	'Class:URP_UserOrg/Attribute:userlogin' => '登录名',
	'Class:URP_UserOrg/Attribute:userlogin+' => '用户的登录名',
	'Class:URP_UserOrg/Attribute:allowed_org_id' => '组织',
	'Class:URP_UserOrg/Attribute:allowed_org_id+' => '可以访问的组织',
	'Class:URP_UserOrg/Attribute:allowed_org_name' => '组织',
	'Class:URP_UserOrg/Attribute:allowed_org_name+' => '可以访问的组织',
	'Class:URP_UserOrg/Attribute:reason' => '原因',
	'Class:URP_UserOrg/Attribute:reason+' => '解释为什么此用户可以访问此组织的数据',
));

//
// Class: URP_ProfileProjection
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_ProfileProjection' => '角色映射',
	'Class:URP_ProfileProjection+' => '角色映射',
	'Class:URP_ProfileProjection/Attribute:dimensionid' => '维度',
	'Class:URP_ProfileProjection/Attribute:dimensionid+' => '应用维度',
	'Class:URP_ProfileProjection/Attribute:dimension' => '维度',
	'Class:URP_ProfileProjection/Attribute:dimension+' => '应用维度',
	'Class:URP_ProfileProjection/Attribute:profileid' => '角色',
	'Class:URP_ProfileProjection/Attribute:profileid+' => '使用角色',
	'Class:URP_ProfileProjection/Attribute:profile' => '角色',
	'Class:URP_ProfileProjection/Attribute:profile+' => '角色名称',
	'Class:URP_ProfileProjection/Attribute:value' => '值表达式',
	'Class:URP_ProfileProjection/Attribute:value+' => 'OQL 表达式 (使用$user) | constant |  | +attribute code',
	'Class:URP_ProfileProjection/Attribute:attribute' => '属性',
	'Class:URP_ProfileProjection/Attribute:attribute+' => '目标属性编码 (可选)',
));

//
// Class: URP_ClassProjection
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_ClassProjection' => '类型映射',
	'Class:URP_ClassProjection+' => '类型映射',
	'Class:URP_ClassProjection/Attribute:dimensionid' => '维度',
	'Class:URP_ClassProjection/Attribute:dimensionid+' => '应用维度',
	'Class:URP_ClassProjection/Attribute:dimension' => '维度',
	'Class:URP_ClassProjection/Attribute:dimension+' => '应用维度',
	'Class:URP_ClassProjection/Attribute:class' => '类型',
	'Class:URP_ClassProjection/Attribute:class+' => '目标类型',
	'Class:URP_ClassProjection/Attribute:value' => '值表达式',
	'Class:URP_ClassProjection/Attribute:value+' => 'OQL表达式 (使用$this) | constant |  | +attribute code',
	'Class:URP_ClassProjection/Attribute:attribute' => '属性',
	'Class:URP_ClassProjection/Attribute:attribute+' => '目标属性编码 (可选)',
));

//
// Class: URP_ActionGrant
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_ActionGrant' => '操作权限',
	'Class:URP_ActionGrant+' => '类型权限',
	'Class:URP_ActionGrant/Attribute:profileid' => '角色',
	'Class:URP_ActionGrant/Attribute:profileid+' => '使用角色',
	'Class:URP_ActionGrant/Attribute:profile' => '角色',
	'Class:URP_ActionGrant/Attribute:profile+' => '使用角色',
	'Class:URP_ActionGrant/Attribute:class' => '类型',
	'Class:URP_ActionGrant/Attribute:class+' => '目标类型',
	'Class:URP_ActionGrant/Attribute:permission' => '权限',
	'Class:URP_ActionGrant/Attribute:permission+' => '允许或不允许 ?',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes' => '是',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes+' => '是',
	'Class:URP_ActionGrant/Attribute:permission/Value:no' => '否',
	'Class:URP_ActionGrant/Attribute:permission/Value:no+' => '否',
	'Class:URP_ActionGrant/Attribute:action' => '操作',
	'Class:URP_ActionGrant/Attribute:action+' => '可用于指定类型上的操作权限',
));

//
// Class: URP_StimulusGrant
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_StimulusGrant' => '权限调整',
	'Class:URP_StimulusGrant+' => '对象生命周期中权限的调整',
	'Class:URP_StimulusGrant/Attribute:profileid' => '角色',
	'Class:URP_StimulusGrant/Attribute:profileid+' => '使用角色',
	'Class:URP_StimulusGrant/Attribute:profile' => '角色',
	'Class:URP_StimulusGrant/Attribute:profile+' => '使用角色',
	'Class:URP_StimulusGrant/Attribute:class' => '类型',
	'Class:URP_StimulusGrant/Attribute:class+' => '目标类型',
	'Class:URP_StimulusGrant/Attribute:permission' => '权限',
	'Class:URP_StimulusGrant/Attribute:permission+' => '允许或不允许 ?',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes' => '是',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes+' => '是',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no' => '否',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no+' => '否',
	'Class:URP_StimulusGrant/Attribute:stimulus' => '调整',
	'Class:URP_StimulusGrant/Attribute:stimulus+' => '调整编码',
));

//
// Class: URP_AttributeGrant
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:URP_AttributeGrant' => '属性权限',
	'Class:URP_AttributeGrant+' => '属性的权限',
	'Class:URP_AttributeGrant/Attribute:actiongrantid' => '操作权限',
	'Class:URP_AttributeGrant/Attribute:actiongrantid+' => '操作权限',
	'Class:URP_AttributeGrant/Attribute:attcode' => '属性',
	'Class:URP_AttributeGrant/Attribute:attcode+' => '属性编码',
));

//
// Class: UserDashboard
//
Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Class:UserDashboard' => '用户仪表盘',
	'Class:UserDashboard+' => '',
	'Class:UserDashboard/Attribute:user_id' => '用户',
	'Class:UserDashboard/Attribute:user_id+' => '',
	'Class:UserDashboard/Attribute:menu_code' => '菜单编码',
	'Class:UserDashboard/Attribute:menu_code+' => '',
	'Class:UserDashboard/Attribute:contents' => '内容',
	'Class:UserDashboard/Attribute:contents+' => '',
));

//
// Duplicated into itop-welcome-itil ( will be removed from here...)
//
Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Menu:WelcomeMenu' => '欢迎',
	'Menu:WelcomeMenu+' => '欢迎使用'.ITOP_APPLICATION_SHORT,
	'Menu:WelcomeMenuPage' => '欢迎',
	'Menu:WelcomeMenuPage+' => '欢迎使用'.ITOP_APPLICATION_SHORT,
	'Menu:AdminTools' => '管理',
	'Menu:AdminTools+' => '管理工具',
	'Menu:AdminTools?' => '具有管理员角色的用户才能使用的工具',
	'Menu:CSVImportMenu' => 'CSV 导入',
	'Menu:CSVImportMenu+' => '批量创建或修改',
	'Menu:DataModelMenu' => '数据模型',
	'Menu:DataModelMenu+' => '数据模型概况',
	'Menu:ExportMenu' => '导出',
	'Menu:ExportMenu+' => '以 HTML,CSV 或 XML 格式导出任何查询的结果',
	'Menu:NotificationsMenu' => '通知',
	'Menu:NotificationsMenu+' => '配置通知',
	'Menu:MyShortcuts' => '我的快捷方式',
	'Menu:DataAdministration' => '数据管理',
	'Menu:DataAdministration+' => '数据管理',
));

//
// String from the User Interface: menu, messages, buttons, etc...
//

Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'BooleanLabel:yes' => '是',
	'BooleanLabel:no' => '否',
	'UI:Login:Title' => ITOP_APPLICATION_SHORT.'登录',
	'UI:WelcomeMenu:Title' => '欢迎使用'.ITOP_APPLICATION_SHORT, 'UI:WelcomeMenu:AllOpenRequests' => '所有打开的需求: %1$d',
	'UI:WelcomeMenu:MyCalls' => '我办理的需求',
	'UI:WelcomeMenu:OpenIncidents' => '所有打开的事件: %1$d',
	'UI:WelcomeMenu:AllConfigItems' => '配置项: %1$d',
	'UI:WelcomeMenu:MyIncidents' => '分配给我的事件',
	'UI:AllOrganizations' => ' 所有组织 ',
	'UI:YourSearch' => '搜索',
	'UI:LoggedAsMessage' => '以 %1$s 身份登录 (%2$s)',
	'UI:LoggedAsMessage+Admin' => '以 %1$s 身份登录 (%2$s, 管理员)',
	'UI:Button:Logoff' => '注销',
	'UI:Button:GlobalSearch' => '搜索',
	'UI:Button:Search' => ' 搜索 ',
	'UI:Button:Clear' => ' 清空 ',
	'UI:Button:Confirm' => ' 确认 ',
	'UI:Button:SearchInHierarchy' => '递归搜索',
	'UI:Button:Query' => ' 查询 ',
	'UI:Button:Ok' => 'OK',
	'UI:Button:Save' => '保存',
	'UI:Button:SaveAnd' => '保存并%1$s',
	'UI:Button:Cancel' => '取消',
	'UI:Button:Close' => '关闭',
	'UI:Button:Apply' => '应用',
	'UI:Button:Send' => '发送',
	'UI:Button:SendAnd' => '发送并%1$s',
	'UI:Button:Back' => ' << 上一步 ',
	'UI:Button:Restart' => ' |<< 重来 ',
	'UI:Button:Next' => ' 下一步 >> ',
	'UI:Button:Finish' => ' 结束 ',
	'UI:Button:DoImport' => ' 执行导入 ! ',
	'UI:Button:Done' => ' 完成 ',
	'UI:Button:SimulateImport' => ' 模拟导入 ',
	'UI:Button:Test' => '测试!',
	'UI:Button:Evaluate' => ' 评估 ',
	'UI:Button:Evaluate:Title' => ' 评估 (Ctrl+Enter) ',
	'UI:Button:AddObject' => ' 添加... ',
	'UI:Button:BrowseObjects' => ' 浏览... ',
	'UI:Button:Add' => ' 添加 ',
	'UI:Button:AddToList' => ' << 添加 ',
	'UI:Button:RemoveFromList' => ' 移除 >> ',
	'UI:Button:FilterList' => ' 筛选... ',
	'UI:Button:Create' => ' 创建 ',
	'UI:Button:Delete' => ' 删除 ',
	'UI:Button:Rename' => ' 重命名... ',
	'UI:Button:ChangePassword' => ' 修改密码 ',
	'UI:Button:ResetPassword' => ' 重置密码 ',
	'UI:Button:Insert' => '插入',
	'UI:Button:More' => '更多',
	'UI:Button:Less' => '更少',
	'UI:Button:Wait' => '正在更新字段,请稍候',
	'UI:Treeview:CollapseAll' => '全部收起',
	'UI:Treeview:ExpandAll' => '全部展开',
	'UI:UserPref:DoNotShowAgain' => '不再显示',
	'UI:InputFile:NoFileSelected' => '未选择文件',
	'UI:InputFile:SelectFile' => '选择文件',
	'UI:SearchToggle' => '搜索',
	'UI:ClickToCreateNew' => '新建%1$s',
	'UI:SearchFor_Class' => '搜索%1$s ',
	'UI:NoObjectToDisplay' => '没有可显示的对象.',
	'UI:Error:SaveFailed' => '对象无法被保存:',
	'UI:Error:MandatoryTemplateParameter_object_id' => '当link_attr被指定时, 参数object_id是必须的. 请检查显示模板的定义.',
	'UI:Error:MandatoryTemplateParameter_target_attr' => '当link_attr被指定时, 参数target_attr是必须的. 请检查显示模板的定义.',
	'UI:Error:MandatoryTemplateParameter_group_by' => '参数group_by是必须的. 请检查显示模板的定义.',
	'UI:Error:InvalidGroupByFields' => '分组字段列表是无效的: "%1$s".',
	'UI:Error:UnsupportedStyleOfBlock' => '错误: 不被支持的block格式: "%1$s".',
	'UI:Error:IncorrectLinkDefinition_LinkedClass_Class' => '关联错误: 关联的对象: %1$s不是%2$s的外键',
	'UI:Error:Object_Class_Id_NotFound' => '对象: %1$s:%2$d找不到.',
	'UI:Error:WizardCircularReferenceInDependencies' => '错误: 字段之间的依赖性出现循环引用, 请检查数据模型.',
	'UI:Error:UploadedFileTooBig' => '上传文件太大. (允许的最大限制是 %1$s). 请检查 PHP 配置文件中的upload_max_filesize和post_max_size.',
	'UI:Error:UploadedFileTruncated.' => '上传的文件被截断 !',
	'UI:Error:NoTmpDir' => '未定义临时目录.',
	'UI:Error:CannotWriteToTmp_Dir' => '无法向硬盘写入临时文件. upload_tmp_dir = "%1$s".',
	'UI:Error:UploadStoppedByExtension_FileName' => '上传因为扩展名被停止. (原文件名 = "%1$s").',
	'UI:Error:UploadFailedUnknownCause_Code' => '文件上传失败, 原因未知. (错误代码 = "%1$s").',
	'UI:Error:1ParametersMissing' => '错误: 必须为此操作指定以下参数: %1$s.',
	'UI:Error:2ParametersMissing' => '错误: 必须为此操作指定以下参数: %1$s和%2$s.',
	'UI:Error:3ParametersMissing' => '错误: 必须为此操作指定以下参数: %1$s, %2$s和%3$s.',
	'UI:Error:4ParametersMissing' => '错误: 必须为此操作指定以下参数: %1$s, %2$s, %3$s和%4$s.',
	'UI:Error:IncorrectOQLQuery_Message' => '错误: 错误的OQL查询: %1$s',
	'UI:Error:AnErrorOccuredWhileRunningTheQuery_Message' => '运行此查询时发生了一个错误: %1$s',
	'UI:Error:ObjectAlreadyUpdated' => '错误: 此对象已更新.',
	'UI:Error:ObjectCannotBeUpdated' => '错误: 对象无法更新.',
	'UI:Error:ObjectsAlreadyDeleted' => '错误: 对象已被删除!',
	'UI:Error:BulkDeleteNotAllowedOn_Class' => '您无权进行%1$s类型对象的批量删除',
	'UI:Error:DeleteNotAllowedOn_Class' => '您无权删除%1$s类型的对象',
	'UI:Error:ReadNotAllowedOn_Class' => '您无权查看对象的%1$s',
	'UI:Error:BulkModifyNotAllowedOn_Class' => '您无权进行%1$s类型对象的批量更新',
	'UI:Error:ObjectAlreadyCloned' => '错误: 此对象已被克隆!',
	'UI:Error:ObjectAlreadyCreated' => '错误: 此对象已被创建!',
	'UI:Error:Invalid_Stimulus_On_Object_In_State' => '错误: 在对象%2$s的 "%3$s" 状态上的无效权限 "%1$s".',
	'UI:Error:InvalidDashboardFile' => '错误: 无效的仪表盘文件',
	'UI:Error:InvalidDashboard' => '错误: 无效的仪表盘',
	'UI:Error:MaintenanceMode' => '应用正处于维护中',
	'UI:Error:MaintenanceTitle' => '维护',
	'UI:Error:InvalidToken' => '错误: 所请求的操作已执行 (没有CSRF token)',
	'UI:Error:SMTP:UnknownVendor' => 'OAuth SMTP提供者%1$s不存在 (email_transport_smtp.oauth.provider)',
	'UI:GroupBy:Count' => '个数',
	'UI:GroupBy:Count+' => '项目数',
	'UI:CountOfObjects' => '%1$d个对象符合指定的条件.',
	'UI_CountOfObjectsShort' => '%1$d个对象.',
	'UI:NoObject_Class_ToDisplay' => '没有%1$s可以显示',
	'UI:History:LastModified_On_By' => '最后修改%1$s被%2$s.',
	'UI:HistoryTab' => '历史',
	'UI:NotificationsTab' => '通知',
	'UI:History:BulkImports' => '历史',
	'UI:History:BulkImports+' => 'CSV导入列表 (最新导入在最)',
	'UI:History:BulkImportDetails' => '在%1$s执行CSV导入时造成的变更 (由%2$s)',
	'UI:History:Date' => '日期',
	'UI:History:Date+' => '变更日期',
	'UI:History:User' => '用户',
	'UI:History:User+' => '执行修改的用户',
	'UI:History:Changes' => '修改',
	'UI:History:Changes+' => '对此对象所做的修改',
	'UI:History:StatsCreations' => '已创建',
	'UI:History:StatsCreations+' => '已创建的对象个数',
	'UI:History:StatsModifs' => '已修改',
	'UI:History:StatsModifs+' => '已修改的对象个数',
	'UI:History:StatsDeletes' => '已删除',
	'UI:History:StatsDeletes+' => '已删除的对象个数',
	'UI:Loading' => '正在加载...',
	'UI:Menu:Actions' => '操作',
	'UI:Menu:OtherActions' => '其它操作',
	'UI:Menu:Transitions' => '转换状态',
	'UI:Menu:OtherTransitions' => '其它变化',
	'UI:Menu:View' => '查看对象',
	'UI:Menu:New' => '新建...',
	'UI:Menu:Add' => '添加...',
	'UI:Menu:Manage' => '管理...',
	'UI:Menu:EMail' => '邮件',
	'UI:Menu:CSVExport' => 'CSV导出...',
	'UI:Menu:OpenOQL' => 'View the OQL query~~',
	'UI:Menu:Modify' => '修改...',
	'UI:Menu:Delete' => '删除...',
	'UI:Menu:BulkDelete' => '删除...',
	'UI:Menu:BulkDelete_Class' => '删除%1$s个对象...',
	'UI:Menu:BulkDelete_Link' => '删除%1$s...',
	'UI:Menu:BulkDelete_Remote' => '删除%1$s...',
	'UI:UndefinedObject' => '未定义',
	'UI:Document:OpenInNewWindow:Download' => '在新窗口打开: %1$s, 下载: %2$s',
	'UI:SplitDateTime-Date' => '日期',
	'UI:SplitDateTime-Time' => '时间',
	'UI:TruncatedResults' => '显示 %1$d 个对象,共 %2$d 个',
	'UI:DisplayAll' => '全部显示',
	'UI:CollapseList' => '收起',
	'UI:CountOfResults' => '%1$d个对象',
	'UI:ChangesLogTitle' => '变更记录 (%1$d):',
	'UI:EmptyChangesLogTitle' => '变更记录为空',
	'UI:SearchFor_Class_Objects' => '搜索%1$s',
	'UI:OQLQueryBuilderTitle' => 'OQL 查询构建器',
	'UI:OQLQueryTab' => 'OQL 查询',
	'UI:SimpleSearchTab' => '简易搜索',
	'UI:Details+' => '详情',
	'UI:SearchValue:Any' => '* 任何 *',
	'UI:SearchValue:Mixed' => '* 混合 *',
	'UI:SearchValue:NbSelected' => '# 已选择',
	'UI:SearchValue:CheckAll' => '全选',
	'UI:SearchValue:UncheckAll' => '反选',
	'UI:SelectOne' => '-- 请选择 --',
	'UI:Login:Welcome' => '欢迎使用'.ITOP_APPLICATION_SHORT.'!',
	'UI:Login:IncorrectLoginPassword' => '用户名或密码错误, 请重试.',
	'UI:Login:IdentifyYourself' => '请完成身份认证',
	'UI:Login:UserNamePrompt' => '用户名',
	'UI:Login:PasswordPrompt' => '密码',
	'UI:Login:ForgotPwd' => '忘记密码?',
	'UI:Login:ForgotPwdForm' => '忘记密码',
	'UI:Login:ForgotPwdForm+' => ITOP_APPLICATION_SHORT.'将会给您发送一封密码重置邮件.',
	'UI:Login:ResetPassword' => '立即发送!',
	'UI:Login:ResetPwdFailed' => '邮件发送失败: %1$s',
	'UI:Login:SeparatorOr' => '或',
	'UI:ResetPwd-Error-WrongLogin' => '\'%1$s\' 用户名无效',
	'UI:ResetPwd-Error-NotPossible' => '外部账号不允许重置密码.',
	'UI:ResetPwd-Error-FixedPwd' => '此账号不允许重置密码.',
	'UI:ResetPwd-Error-NoContact' => '此账号没有关联到人员.',
	'UI:ResetPwd-Error-NoEmailAtt' => '此账号未关联邮箱地址,请联系管理员.',
	'UI:ResetPwd-Error-NoEmail' => '缺少邮箱地址. 请联系管理员.',
	'UI:ResetPwd-Error-Send' => '邮件发送存在技术原因. 请联系管理员.',
	'UI:ResetPwd-EmailSent' => '请检查您的收件箱并根据指引进行操作. 如果您没有收到邮件, 请检查您登录时的输入是否存在错误.',
	'UI:ResetPwd-EmailSubject' => '重置'.ITOP_APPLICATION_SHORT.'密码',
	'UI:ResetPwd-EmailBody' => '<body><p>您已请求重置'.ITOP_APPLICATION_SHORT.'密码.</p><p>请点击这个链接 (一次性) <a href="%1$s">来输入新的密码</a></p>.',
	'UI:ResetPwd-Title' => '重置密码',
	'UI:ResetPwd-Error-InvalidToken' => '对不起, 密码已经被重置, 请检查是否收到了多封密码重置邮件. 请点击最新邮件里的链接.',
	'UI:ResetPwd-Error-EnterPassword' => '请输入 \'%1$s\' 的新密码.',
	'UI:ResetPwd-Ready' => '密码已修改成功.',
	'UI:ResetPwd-Login' => '点击这里登录...',
	'UI:Login:About' => ITOP_APPLICATION.'由 Combodo 创建',
	'UI:Login:ChangeYourPassword' => '修改您的密码',
	'UI:Login:OldPasswordPrompt' => '旧密码',
	'UI:Login:NewPasswordPrompt' => '新密码',
	'UI:Login:RetypeNewPasswordPrompt' => '重复新密码',
	'UI:Login:IncorrectOldPassword' => '错误: 旧密码错误',
	'UI:LogOffMenu' => '注销',
	'UI:LogOff:ThankYou' => '感谢使用'.ITOP_APPLICATION, 'UI:LogOff:ClickHereToLoginAgain' => '点击这里再次登录...',
	'UI:ChangePwdMenu' => '修改密码...',
	'UI:Login:PasswordChanged' => '密码已成功设置!',
	'UI:Login:PasswordNotChanged' => '错误!密码未改变!',
	'UI:AccessRO-All' => ITOP_APPLICATION.'是只读的',
	'UI:AccessRO-Users' => ITOP_APPLICATION.'对于终端用户是只读的',
	'UI:ApplicationEnvironment' => '应用环境: %1$s',
	'UI:Login:RetypePwdDoesNotMatch' => '新密码输入不一致!',
	'UI:Button:Login' => '登录'.ITOP_APPLICATION_SHORT, 'UI:Login:Error:AccessRestricted' => ITOP_APPLICATION_SHORT.'访问被限制. 请联系管理员.',
	'UI:Login:Error:AccessAdmin' => '只有具有管理员权限的人才能访问. 请联系管理员.',
	'UI:Login:Error:WrongOrganizationName' => '未知组织',
	'UI:Login:Error:MultipleContactsHaveSameEmail' => '多个联系人存在相同的邮箱',
	'UI:Login:Error:NoValidProfiles' => '无效的资料',
	'UI:CSVImport:MappingSelectOne' => '-- 请选择 --',
	'UI:CSVImport:MappingNotApplicable' => '-- 忽略此字段 --',
	'UI:CSVImport:NoData' => '数据为空..., 请提供数据!',
	'UI:Title:DataPreview' => '数据预览',
	'UI:CSVImport:ErrorOnlyOneColumn' => '错误: 数据仅包含一列. 您选择了合适的分隔符了吗?',
	'UI:CSVImport:FieldName' => '字段 %1$d',
	'UI:CSVImport:DataLine1' => '数据行 1',
	'UI:CSVImport:DataLine2' => '数据行 2',
	'UI:CSVImport:idField' => 'id (主键)',
	'UI:Title:BulkImport' => ITOP_APPLICATION_SHORT.' - 批量导入',
	'UI:Title:BulkImport+' => 'CSV 导入向导',
	'UI:Title:BulkSynchro_nbItem_ofClass_class' => '同步 %2$s 个对象中的 %1$d',
	'UI:CSVImport:ClassesSelectOne' => '-- 请选择 --',
	'UI:CSVImport:ErrorExtendedAttCode' => '内部错误: "%1$s" 是错误的编码, 因为 "%2$s" 不是类型 "%3$s" 的外键',
	'UI:CSVImport:ObjectsWillStayUnchanged' => '%1$d个对象保持不变.',
	'UI:CSVImport:ObjectsWillBeModified' => '%1$d个对象将被修改.',
	'UI:CSVImport:ObjectsWillBeAdded' => '%1$d个对象将被添加.',
	'UI:CSVImport:ObjectsWillHaveErrors' => '%1$d个对象将发生错误.',
	'UI:CSVImport:ObjectsRemainedUnchanged' => '%1$d个对象保持不变.',
	'UI:CSVImport:ObjectsWereModified' => '%1$d个对象已被修改.',
	'UI:CSVImport:ObjectsWereAdded' => '%1$d个对象已被添加.',
	'UI:CSVImport:ObjectsHadErrors' => '%1$d个对象发生错误.',
	'UI:Title:CSVImportStep2' => '第2步,共5步: CSV数据选项',
	'UI:Title:CSVImportStep3' => '第3步,共5步: 数据映射',
	'UI:Title:CSVImportStep4' => '第4步,共5步: 模拟导入',
	'UI:Title:CSVImportStep5' => '第5步,共5步: 完成导入',
	'UI:CSVImport:LinesNotImported' => '无法导入的行:',
	'UI:CSVImport:LinesNotImported+' => '以下行无法导入因为其中包含错误',
	'UI:CSVImport:SeparatorComma+' => ', (逗号)',
	'UI:CSVImport:SeparatorSemicolon+' => '; (分号)',
	'UI:CSVImport:SeparatorTab+' => '制表符',
	'UI:CSVImport:SeparatorOther' => '其它:',
	'UI:CSVImport:QualifierDoubleQuote+' => '" (双引号)',
	'UI:CSVImport:QualifierSimpleQuote+' => '\' (单引号)',
	'UI:CSVImport:QualifierOther' => '其它:',
	'UI:CSVImport:TreatFirstLineAsHeader' => '将第一行视作标题头 (列名)',
	'UI:CSVImport:Skip_N_LinesAtTheBeginning' => '跳过文件的前%1$s行',
	'UI:CSVImport:CSVDataPreview' => 'CSV 数据预览',
	'UI:CSVImport:Column' => 'Column %1$s~~',
	'UI:CSVImport:SelectFile' => '请选择要导入的文件:',
	'UI:CSVImport:Tab:LoadFromFile' => '从文件导入',
	'UI:CSVImport:Tab:CopyPaste' => '复制和粘贴的数据',
	'UI:CSVImport:Tab:Templates' => '模板',
	'UI:CSVImport:PasteData' => '粘贴数据以导入:',
	'UI:CSVImport:PickClassForTemplate' => '选择模板: ',
	'UI:CSVImport:SeparatorCharacter' => '分隔符:',
	'UI:CSVImport:TextQualifierCharacter' => '文本修饰符',
	'UI:CSVImport:CommentsAndHeader' => '注释和头',
	'UI:CSVImport:SelectClass' => '选择要导入的类别:',
	'UI:CSVImport:AdvancedMode' => '高级模式',
	'UI:CSVImport:AdvancedMode+' => '在高级模式中, 对象的"id" (主键) 可以被用来修改和重命名对象.不管怎样, 列 "id" (如果存在) 只能被用做一个搜索条件, 不能与其它搜索条件混用.',
	'UI:CSVImport:SelectAClassFirst' => '要配置映射, 请先选择一个类型.',
	'UI:CSVImport:HeaderFields' => '字段',
	'UI:CSVImport:HeaderMappings' => '映射',
	'UI:CSVImport:HeaderSearch' => '搜索?',
	'UI:CSVImport:AlertIncompleteMapping' => '请为每个栏选择一个映射.',
	'UI:CSVImport:AlertMultipleMapping' => '请确保目标区域仅被映射一次.',
	'UI:CSVImport:AlertNoSearchCriteria' => '请选择至少一个搜索条件',
	'UI:CSVImport:Encoding' => '字符编码',
	'UI:CSVImport:ViewAllPossibleValues' => '查看所有可能值',
	'UI:CSVImport:ViewAllAmbiguousValues' => '查看所有模糊值',
	'UI:UniversalSearchTitle' => ITOP_APPLICATION_SHORT.' - 全局搜索',
	'UI:UniversalSearch:Error' => '错误: %1$s',
	'UI:UniversalSearch:LabelSelectTheClass' => '选择要搜索的类别: ',
	'UI:CSVReport-Value-Modified' => '已修改',
	'UI:CSVReport-Value-SetIssue' => '属性值不合法',
	'UI:CSVReport-Value-ChangeIssue' => '\'%1$s\' 值不合法',
	'UI:CSVReport-Value-NoMatch' => '没有匹配到值 \'%1$s\'',
	'UI:CSVReport-Value-NoMatch-PossibleValues' => '一些可能的 \'%1$s\' 值: %2$s',
	'UI:CSVReport-Value-NoMatch-NoObject' => '对象 \'%1$s\' 不存在',
	'UI:CSVReport-Value-NoMatch-NoObject-ForCurrentUser' => '对象 \'%1$s\' 在您当前角色下没有找到',
	'UI:CSVReport-Value-NoMatch-SomeObjectNotVisibleForCurrentUser' => '一些对象 \'%1$s\' 在您当前角色下不可见',
	'UI:CSVReport-Value-Missing' => '缺少必填项',
	'UI:CSVReport-Value-Ambiguous' => '模糊匹配: 找到 %1$s 个对象',
	'UI:CSVReport-Row-Unchanged' => '保持不变',
	'UI:CSVReport-Row-Created' => '新建',
	'UI:CSVReport-Row-Updated' => '已更新 %1$d 列',
	'UI:CSVReport-Row-Disappeared' => '已消失, %1$d 列发生变化',
	'UI:CSVReport-Row-Issue' => '问题: %1$s',
	'UI:CSVReport-Value-Issue-Null' => '不允许留空',
	'UI:CSVReport-Value-Issue-NotFound' => '对象找不到',
	'UI:CSVReport-Value-Issue-FoundMany' => '找到 %1$d 个匹配项',
	'UI:CSVReport-Value-Issue-Readonly' => '\'%1$s\' 的属性是只读的,不能修改 (当前值: %2$s, 建议值: %3$s)',
	'UI:CSVReport-Value-Issue-Format' => '输入处理失败: %1$s',
	'UI:CSVReport-Value-Issue-NoMatch' => '属性 \'%1$s\' 未知的值: 无法匹配, 请检查拼写',
	'UI:CSVReport-Value-Issue-AllowedValues' => '允许 \'%1$s\' 值: %2$s',
	'UI:CSVReport-Value-Issue-Unknown' => '属性 \'%1$s\' 未知的值: %2$s',
	'UI:CSVReport-Row-Issue-Inconsistent' => '属性不一致: %1$s',
	'UI:CSVReport-Row-Issue-Attribute' => '错误的属性',
	'UI:CSVReport-Row-Issue-MissingExtKey' => '创建失败, 因为缺少外键: %1$s',
	'UI:CSVReport-Row-Issue-DateFormat' => '日期格式错误',
	'UI:CSVReport-Row-Issue-ExpectedDateFormat' => '预期格式: %1$s',
	'UI:CSVReport-Row-Issue-Reconciliation' => '无法保持一致',
	'UI:CSVReport-Row-Issue-Ambiguous' => '不明确的一致要求',
	'UI:CSVReport-Row-Issue-Internal' => '内部错误: %1$s, %2$s',
	'UI:CSVReport-Icon-Unchanged' => '保持不变',
	'UI:CSVReport-Icon-Modified' => '修改',
	'UI:CSVReport-Icon-Missing' => '丢失',
	'UI:CSVReport-Object-MissingToUpdate' => '丢失对象: 将被更新',
	'UI:CSVReport-Object-MissingUpdated' => '丢失对象: 已更新',
	'UI:CSVReport-Icon-Created' => '创建',
	'UI:CSVReport-Object-ToCreate' => '对象将被创建',
	'UI:CSVReport-Object-Created' => '对象已创建',
	'UI:CSVReport-Icon-Error' => '错误',
	'UI:CSVReport-Object-Error' => '错误: %1$s',
	'UI:CSVReport-Object-Ambiguous' => '模糊: %1$s',
	'UI:CSVReport-Stats-Errors' => '%1$.0f %% 已加载的对象包含错误, 它们将会被忽略.',
	'UI:CSVReport-Stats-Created' => '%1$.0f %% 已加载的对象将会被创建.',
	'UI:CSVReport-Stats-Modified' => '%1$.0f %% 已加载的对象将会被修改.',
	'UI:CSVExport:AdvancedMode' => '高级模式',
	'UI:CSVExport:AdvancedMode+' => '高级模式下, 导出将包含额外的列: 对象id, 外键id以及要使一致的属性.',
	'UI:CSVExport:LostChars' => '编码问题',
	'UI:CSVExport:LostChars+' => '已下载文件将使用编码 %1$s. 系统检测到一些字符与该格式不兼容. 这些字符将被替换为子集 (例如重读字符将丢失音调), 或者被丢弃. 您可以从浏览器中复制粘贴数据. 或者联系管理员更改字符编码 (参阅参数 \'csv_file_default_charset\').',
	'UI:Audit:Title' => ITOP_APPLICATION_SHORT.' - CMDB审计',
	'UI:Audit:Interactive:All:Title' => '审计结果',
	'UI:Audit:Interactive:All:SubTitle' => '全量审计: 包括所有规则, 所有类别, 所有审计域',
	'UI:Audit:Interactive:All:BreadCrumb' => '全量审计',
	'UI:Audit:Interactive:All:BreadCrumb+' => '所有规则的审计结果',
	'UI:Audit:Interactive:Categories:Title' => '所有类别的审计结果: %1$s',
	'UI:Audit:Interactive:Categories:SubTitle' => '所有属于类别%1$s的规则的审计结果',
	'UI:Audit:Interactive:Categories:BreadCrumb' => '类别',
	'UI:Audit:Interactive:Categories:BreadCrumb+' => '审计类别: %1$s',
	'UI:Audit:Interactive:Domain:Title' => '审计结果在域: %1$s',
	'UI:Audit:Interactive:Domain:SubTitle' => '所有关联所述域的类别内的审计规则的结果: %1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb' => '全量审计',
	'UI:Audit:Interactive:Domain:BreadCrumb+' => '审计在域: %1$s',
	'UI:Audit:Interactive:Selection:Title' => '审计的选择',
	'UI:Audit:Interactive:Selection:SubTitle' => '选择一个域以将结果限定在该域内或者选择 "所有类别" 进行全量审计 (要审计的数据太大可能导致耗时较长甚至失败)',
	'UI:Audit:Interactive:Selection:BreadCrumb' => '选择',
	'UI:Audit:Interactive:Selection:BreadCrumb+' => '选择要运行的审计',
	'UI:Audit:Interactive:Selection:BadgeAll' => '所有类别',
	'UI:Audit:Interactive:Button:Back' => '返回审计',
	'UI:Audit:Interactive:Button:Configuration' => '审计配置',
	'UI:Audit:ViewRules' => '检查规则',
	'UI:Audit:HeaderAuditRule' => '审计规则',
	'UI:Audit:HeaderNbObjects' => '# 对象',
	'UI:Audit:HeaderNbErrors' => '# 错误',
	'UI:Audit:PercentageOk' => '% Ok',
	'UI:Audit:OqlError' => 'OQL 错误',
	'UI:Audit:Error:ValueNA' => 'n/a',
	'UI:Audit:ErrorIn_Rule' => '规则中有错误',
	'UI:Audit:ErrorIn_Rule_Reason' => 'OQL错误在规则%1$s中: %2$s.',
	'UI:Audit:ErrorIn_Category' => '类别中有错误',
	'UI:Audit:ErrorIn_Category_Reason' => 'OQL错误在类别%1$s中: %2$s.',
	'UI:Audit:AuditErrors' => '审计出错',
	'UI:Audit:Dashboard:ObjectsAudited' => '对象已审计',
	'UI:Audit:Dashboard:ObjectsInError' => '对象出错',
	'UI:Audit:Dashboard:ObjectsValidated' => '对象已验证',
	'UI:Audit:AuditCategory:Subtitle' => '%2$s个中有%1$s个错误 - %3$s%%',
	'UI:RunQuery:Title' => ITOP_APPLICATION_SHORT.' - OQL查询评估',
	'UI:RunQuery:QueryExamples' => '示例查询',
	'UI:RunQuery:QueryResults' => '查询结果',
	'UI:RunQuery:HeaderPurpose' => '目的',
	'UI:RunQuery:HeaderPurpose+' => '此查询的解释',
	'UI:RunQuery:HeaderOQLExpression' => 'OQL 表达式',
	'UI:RunQuery:HeaderOQLExpression+' => 'OQL 语法表示的查询',
	'UI:RunQuery:ExpressionToEvaluate' => '请输入表达式: ',
	'UI:RunQuery:QueryArguments' => '查询参数',
	'UI:RunQuery:MoreInfo' => '此查询的更多信息: ',
	'UI:RunQuery:DevelopedQuery' => '快捷查询表达式: ',
	'UI:RunQuery:SerializedFilter' => '序列化的过滤器: ',
	'UI:RunQuery:DevelopedOQL' => '优化的OQL',
	'UI:RunQuery:DevelopedOQLCount' => '开发的OQL计数',
	'UI:RunQuery:ResultSQLCount' => '结果SQL计数',
	'UI:RunQuery:ResultSQL' => '结果SQL',
	'UI:RunQuery:Error' => '运行此查询时发生了一个错误',
	'UI:Query:UrlForExcel' => '用于 MS-Excel 网络查询的 URL',
	'UI:Query:UrlV1' => '没有定义字段列表. 没有这个信息页面<em>export-V2.php</em>无法调用. 因此, 建议的以下 URL 指向传统页面: <em>export.php</em>. 该传统版本导出具有以下限制: 导出的字段列表很大程度依赖于导出格式和'.ITOP_APPLICATION_SHORT.'数据模型. <br/>如果您需要确保导出的列保持长期稳定, 则必须为属性 "Fields" 指定值并使用页面<em>export-V2.php</em>.',
	'UI:Schema:Title' => ITOP_APPLICATION_SHORT.'对象模型',
	'UI:Schema:TitleForClass' => '%1$s 模式',
	'UI:Schema:CategoryMenuItem' => '类别 <b>%1$s</b>',
	'UI:Schema:Relationships' => '关联',
	'UI:Schema:AbstractClass' => '抽象类型: 此类型不能实例化对象.',
	'UI:Schema:NonAbstractClass' => '非抽象类型: 此类型可以实例化对象.',
	'UI:Schema:ClassHierarchyTitle' => '类型层级',
	'UI:Schema:AllClasses' => '所有类型',
	'UI:Schema:ExternalKey_To' => '%1$s 的外键',
	'UI:Schema:Columns_Description' => '列: <em>%1$s</em>',
	'UI:Schema:Default_Description' => '缺省: "%1$s"',
	'UI:Schema:NullAllowed' => '允许留空',
	'UI:Schema:NullNotAllowed' => '不允许留空',
	'UI:Schema:Attributes' => '属性',
	'UI:Schema:AttributeCode' => '属性编码',
	'UI:Schema:AttributeCode+' => '属性的内部编码',
	'UI:Schema:Label' => '标签',
	'UI:Schema:Label+' => '属性标签',
	'UI:Schema:Type' => '类别',
	'UI:Schema:Type+' => '属性的数据类型',
	'UI:Schema:Origin' => '来自',
	'UI:Schema:Origin+' => '此属性被定义的原始类型',
	'UI:Schema:Description' => '描述',
	'UI:Schema:Description+' => '属性的描述',
	'UI:Schema:AllowedValues' => '允许值',
	'UI:Schema:AllowedValues+' => '此属性取值的限制',
	'UI:Schema:MoreInfo' => '更多信息',
	'UI:Schema:MoreInfo+' => '此字段在数据库中被定义的更多信息',
	'UI:Schema:SearchCriteria' => '搜索条件',
	'UI:Schema:FilterCode' => '过滤器编码',
	'UI:Schema:FilterCode+' => '此搜索条件的编码',
	'UI:Schema:FilterDescription' => '描述',
	'UI:Schema:FilterDescription+' => '此搜索条件的描述',
	'UI:Schema:AvailOperators' => '可用的运算符',
	'UI:Schema:AvailOperators+' => '此搜索条件可能的运算符',
	'UI:Schema:ChildClasses' => '子类型',
	'UI:Schema:ReferencingClasses' => '参考类型',
	'UI:Schema:RelatedClasses' => '相关类型',
	'UI:Schema:LifeCycle' => '生命周期',
	'UI:Schema:Triggers' => '触发器',
	'UI:Schema:Relation_Code_Description' => '关联<em>%1$s</em> (%2$s)',
	'UI:Schema:RelationDown_Description' => '向下: %1$s',
	'UI:Schema:RelationUp_Description' => '向上: %1$s',
	'UI:Schema:RelationPropagates' => '%1$s: 延申到 %2$d 个层级, 查询: %3$s',
	'UI:Schema:RelationDoesNotPropagate' => '%1$s: 没有延申(%2$d层级), 查询: %3$s',
	'UI:Schema:Class_ReferencingClasses_From_By' => '%1$s被类型%2$s引用, 通过字段%3$s',
	'UI:Schema:Class_IsLinkedTo_Class_Via_ClassAndAttribute' => '%1$s被链接到%2$s通过 %3$s::<em>%4$s</em>',
	'UI:Schema:Links:1-n' => '类型指向%1$s (1:n链接):',
	'UI:Schema:Links:n-n' => '类型关联到%1$s (n:n链接):',
	'UI:Schema:Links:All' => '全部相关类型的图',
	'UI:Schema:NoLifeCyle' => '此类型没有生命周期的定义.',
	'UI:Schema:LifeCycleTransitions' => '状态转换',
	'UI:Schema:LifeCyleAttributeOptions' => '属性选项',
	'UI:Schema:LifeCycleHiddenAttribute' => '隐藏',
	'UI:Schema:LifeCycleReadOnlyAttribute' => '只读',
	'UI:Schema:LifeCycleMandatoryAttribute' => '必填',
	'UI:Schema:LifeCycleAttributeMustChange' => '必须修改',
	'UI:Schema:LifeCycleAttributeMustPrompt' => '用户将被提示修改',
	'UI:Schema:LifeCycleEmptyList' => '空列表',
	'UI:Schema:ClassFilter' => '类别:',
	'UI:Schema:DisplayLabel' => '显示:',
	'UI:Schema:DisplaySelector/LabelAndCode' => '标记和编码',
	'UI:Schema:DisplaySelector/Label' => '标记',
	'UI:Schema:DisplaySelector/Code' => '编码',
	'UI:Schema:Attribute/Filter' => '筛选器',
	'UI:Schema:DefaultNullValue' => '默认为空: "%1$s"',
	'UI:Schema:Events' => '事件',
	'UI:Schema:Events:Defined' => '已定义事件',
	'UI:Schema:Events:NoEvent' => '无已定义事件',
	'UI:Schema:Events:Listeners' => '事件监听器',
	'UI:Schema:Events:NoListener' => '无事件监听器',
	'UI:Schema:Events:Event' => '事件',
	'UI:Schema:Events:Description' => '描述',
	'UI:Schema:Events:Listener' => '监听器',
	'UI:Schema:Events:Rank' => '评分',
	'UI:Schema:Events:Module' => '模块',
	'UI:LinksWidget:Autocomplete+' => '输入前3个字符...',
	'UI:Edit:SearchQuery' => '请选择预定义的查询',
	'UI:Edit:TestQuery' => '测试查询',
	'UI:Combo:SelectValue' => '--- 请选择 ---',
	'UI:Label:SelectedObjects' => '被选的对象: ',
	'UI:Label:AvailableObjects' => '可用的对象: ',
	'UI:Link_Class_Attributes' => '%1$s 属性',
	'UI:SelectAllToggle+' => '全选/反选',
	'UI:AddObjectsOf_Class_LinkedWith_Class_Instance' => '添加 %1$s 个对象, 链接 %2$s: %3$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class' => ' %1$s ',
	'UI:ManageObjectsOf_Class_LinkedWith_Class_Instance' => '管理 %1$s 个对象, 链接 %2$s: %3$s',
	'UI:AddLinkedObjectsOf_Class' => '添加%1$s',
	'UI:RemoveLinkedObjectsOf_Class' => '移除对象',
	'UI:Message:EmptyList:UseAdd' => '列表为空, 请使用 "添加..." 按扭来添加元素.',
	'UI:Message:EmptyList:UseSearchForm' => '使用上面的搜索表单, 以搜索要添加的对象.',
	'UI:Wizard:FinalStepTitle' => '最后一步: 确认',
	'UI:Title:DeletionOf_Object' => '删除%1$s',
	'UI:Title:BulkDeletionOf_Count_ObjectsOf_Class' => '批量删除 %1$d 个 %2$s 类型的对象',
	'UI:Delete:NotAllowedToDelete' => '您无权删除此对象',
	'UI:Delete:NotAllowedToUpdate_Fields' => '您无权更新以下字段: %1$s',
	'UI:Error:ActionNotAllowed' => '您无权进行操作',
	'UI:Error:NotEnoughRightsToDelete' => '无法删除此对象, 因为当前用户没有足够的权限',
	'UI:Error:CannotDeleteBecause' => '无法删除此对象,因为: %1$s',
	'UI:Error:CannotDeleteBecauseOfDepencies' => '无法删除此对象,因为必须事先完成一些手动操作',
	'UI:Error:CannotDeleteBecauseManualOpNeeded' => '无法删除此对象,因为必须事先完成一些手动操作',
	'UI:Archive_User_OnBehalfOf_User' => '%1$sd 代表 %2$s',
	'UI:Delete:Deleted' => '已删除',
	'UI:Delete:AutomaticallyDeleted' => '已自动删除',
	'UI:Delete:AutomaticResetOf_Fields' => '自动重置字段: %1$s',
	'UI:Delete:CleaningUpRefencesTo_Object' => '删除所有对 %1$s 的引用...',
	'UI:Delete:CleaningUpRefencesTo_Several_ObjectsOf_Class' => '删除所有对 %2$s 类型的 %1$d 个对象的引用...',
	'UI:Delete:Done+' => '做了什么...',
	'UI:Delete:_Name_Class_Deleted' => '%1$s - %2$s已删除.',
	'UI:Delete:ConfirmDeletionOf_Name' => '删除 %1$s',
	'UI:Delete:ConfirmDeletionOf_Count_ObjectsOf_Class' => '删除%2$s类型的%1$d个对象',
	'UI:Delete:CannotDeleteBecause' => '无法删除: %1$s',
	'UI:Delete:ShouldBeDeletedAtomaticallyButNotPossible' => '应该自动删除, 但您无权这样做',
	'UI:Delete:MustBeDeletedManuallyButNotPossible' => '必须手动删除 - 但您无权删除此对象, 请联系管理员%1$s',
	'UI:Delete:WillBeDeletedAutomatically' => '将被自动删除',
	'UI:Delete:MustBeDeletedManually' => '必须手动删除',
	'UI:Delete:CannotUpdateBecause_Issue' => '应该被自动更新, 但是: %1$s',
	'UI:Delete:WillAutomaticallyUpdate_Fields' => '将被自动更新 (重置: %1$s)',
	'UI:Delete:Count_Objects/LinksReferencing_Object' => '一共%1$d个对象/链接 关联了%2$s',
	'UI:Delete:Count_Objects/LinksReferencingTheObjects' => '%1$d个对象/链接关联了一些即将要删除的对象',
	'UI:Delete:ReferencesMustBeDeletedToEnsureIntegrity' => '为了确保数据库的完整性, 任何与之关联的项目也会被删除',
	'UI:Delete:Consequence+' => '要做什么',
	'UI:Delete:SorryDeletionNotAllowed' => '抱歉, 您无权删除此对象, 请看上述详细解释',
	'UI:Delete:PleaseDoTheManualOperations' => '在删除此对象之前, 请先手工完成上述列出的操作',
	'UI:Delect:Confirm_Object' => '请确认要删除%1$s.',
	'UI:Delect:Confirm_Count_ObjectsOf_Class' => '请确认要删除下列%2$s类型的%1$d个对象.',
	'UI:WelcomeToITop' => '欢迎使用'.ITOP_APPLICATION, 'UI:DetailsPageTitle' => ITOP_APPLICATION_SHORT.' - %1$s - %2$s 详细内容',
	'UI:ErrorPageTitle' => ITOP_APPLICATION_SHORT.' - 错误',
	'UI:ObjectDoesNotExist' => '抱歉, 此对象不存在 (或无权浏览此对象).',
	'UI:ObjectArchived' => '对象已被归档. 请启用归档模式或联系管理员.',
	'Tag:Archived' => '已归档',
	'Tag:Archived+' => '仅能在归档模式下访问',
	'Tag:Obsolete' => '已废弃',
	'Tag:Obsolete+' => '从影响分析和搜索结果中排除',
	'Tag:Synchronized' => '已同步',
	'ObjectRef:Archived' => '已归档',
	'ObjectRef:Obsolete' => '已废弃',
	'UI:SearchResultsPageTitle' => ITOP_APPLICATION_SHORT.' - 搜索结果',
	'UI:SearchResultsTitle' => '搜索结果',
	'UI:SearchResultsTitle+' => '全文搜索结果',
	'UI:Search:NoSearch' => '没有可搜索的内容',
	'UI:Search:NeedleTooShort' => '字符串 "%1$s" 太短. 请至少输入 %2$d 个字符.',
	'UI:Search:Ongoing' => '正在搜索 "%1$s"',
	'UI:Search:Enlarge' => '扩大搜索',
	'UI:FullTextSearchTitle_Text' => '"%1$s" 的结果:',
	'UI:Search:Count_ObjectsOf_Class_Found' => '找到 %1$d 个 %2$s.',
	'UI:Search:NoObjectFound' => '未发现对象.',
	'UI:ModificationPageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - %1$s - %2$s 修改',
	'UI:ModificationTitle_Class_Object' => '修改 %1$s: <span class=\\"hilite\\">%2$s</span>',
	'UI:ClonePageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - 克隆 %1$s - %2$s 修改',
	'UI:CloneTitle_Class_Object' => '克隆 %1$s: <span class=\\"hilite\\">%2$s</span>',
	'UI:CreationPageTitle_Class' => ITOP_APPLICATION_SHORT.' - 新建 %1$s',
	'UI:CreationTitle_Class' => '新建 %1$s',
	'UI:SelectTheTypeOf_Class_ToCreate' => '选择 %1$s 的类型:',
	'UI:Class_Object_NotUpdated' => '未发现变化, %1$s (%2$s) <strong>没有</strong>被更新.',
	'UI:Class_Object_Updated' => '%1$s (%2$s) 已更新.',
	'UI:BulkDeletePageTitle' => ITOP_APPLICATION_SHORT.' - 批量删除',
	'UI:BulkDeleteTitle' => '选择您要删除的对象:',
	'UI:PageTitle:ObjectCreated' => ITOP_APPLICATION_SHORT.' 对象已创建.',
	'UI:Title:Object_Of_Class_Created' => '%1$s - %2$s已创建.',
	'UI:Toggle:CustomDashboard' => '自定义',
	'UI:Toggle:StandardDashboard' => '标准',
	'UI:Apply_Stimulus_On_Object_In_State_ToTarget_State' => '应用 %1$s 在对象: %2$s上, 从 %3$s 状态到目标状态: %4$s.',
	'UI:ObjectCouldNotBeWritten' => '对象不能写入: %1$s',
	'UI:PageTitle:FatalError' => ITOP_APPLICATION_SHORT.' - 致命错误',
	'UI:SystemIntrusion' => '访问被禁止. 您正尝试未被许可的操作.',
	'UI:FatalErrorMessage' => '致命错误, '.ITOP_APPLICATION_SHORT.'无法继续.',
	'UI:Error_Details' => '错误: %1$s.',
	'UI:PageTitle:ProfileProjections' => ITOP_APPLICATION_SHORT.'用户管理 - 角色映射',
	'UI:UserManagement:Class' => '类型',
	'UI:UserManagement:Class+' => '对象的类型',
	'UI:UserManagement:ProjectedObject' => '对象',
	'UI:UserManagement:ProjectedObject+' => '被映射的对象',
	'UI:UserManagement:AnyObject' => '* 任何 *',
	'UI:UserManagement:User' => '用户',
	'UI:UserManagement:User+' => '与此映射相关的用户',
	'UI:UserManagement:Action:Read' => '读',
	'UI:UserManagement:Action:Read+' => '读/显示对象',
	'UI:UserManagement:Action:Modify' => '修改',
	'UI:UserManagement:Action:Modify+' => '创建和编辑 (修改) 对象',
	'UI:UserManagement:Action:Delete' => '删除',
	'UI:UserManagement:Action:Delete+' => '删除对象',
	'UI:UserManagement:Action:BulkRead' => '批量读取 (导出)',
	'UI:UserManagement:Action:BulkRead+' => '列出对象或批量导出',
	'UI:UserManagement:Action:BulkModify' => '批量修改',
	'UI:UserManagement:Action:BulkModify+' => '批量创建/编辑 (CSV导入)',
	'UI:UserManagement:Action:BulkDelete' => '批量删除',
	'UI:UserManagement:Action:BulkDelete+' => '批量删除对象',
	'UI:UserManagement:Action:Stimuli' => '调整',
	'UI:UserManagement:Action:Stimuli+' => '允许 (混合) 操作',
	'UI:UserManagement:Action' => '操作',
	'UI:UserManagement:Action+' => '此用户进行的操作',
	'UI:UserManagement:TitleActions' => '操作',
	'UI:UserManagement:Permission' => '权限',
	'UI:UserManagement:Permission+' => '用户的权限',
	'UI:UserManagement:Attributes' => '属性',
	'UI:UserManagement:ActionAllowed:Yes' => '是',
	'UI:UserManagement:ActionAllowed:No' => '否',
	'UI:UserManagement:AdminProfile+' => '管理员拥有数据库中所有对象完整的读/写/访问权限.',
	'UI:UserManagement:NoLifeCycleApplicable' => '不适用',
	'UI:UserManagement:NoLifeCycleApplicable+' => '此类型未定义生命周期',
	'UI:UserManagement:GrantMatrix' => '授权矩阵',
	'Menu:SystemTools' => '系统',
	'UI:ChangeManagementMenu' => '变更管理',
	'UI:ChangeManagementMenu+' => '变更管理',
	'UI:ChangeManagementMenu:Title' => '变更概况',
	'UI-ChangeManagementMenu-ChangesByType' => '按类别划分的变更',
	'UI-ChangeManagementMenu-ChangesByStatus' => '按状态划分的变更',
	'UI-ChangeManagementMenu-ChangesNotYetAssigned' => '尚未分配的变更',
	'UI:ConfigurationManagementMenu' => '配置管理',
	'UI:ConfigurationManagementMenu+' => '配置管理',
	'UI:ConfigurationManagementMenu:Title' => '基础架构概况',
	'UI-ConfigurationManagementMenu-InfraByType' => '按类别划分基础架构对象',
	'UI-ConfigurationManagementMenu-InfraByStatus' => '按状态划分基础架构对象',
	'UI:ConfigMgmtMenuOverview:Title' => '配置管理仪表盘',
	'UI-ConfigMgmtMenuOverview-FunctionalCIbyStatus' => '按状态配置项目',
	'UI-ConfigMgmtMenuOverview-FunctionalCIByType' => '按类别配置项目',
	'UI:RequestMgmtMenuOverview:Title' => '需求管理仪表盘',
	'UI-RequestManagementOverview-RequestByService' => '按服务划分用户需求',
	'UI-RequestManagementOverview-RequestByPriority' => '按优先级划分用户需求',
	'UI-RequestManagementOverview-RequestUnassigned' => '尚未分配给办理人的用户需求',
	'UI:IncidentMgmtMenuOverview:Title' => '事件管理仪表盘',
	'UI-IncidentManagementOverview-IncidentByService' => '按服务级划分事件',
	'UI-IncidentManagementOverview-IncidentByPriority' => '按优先级划分事件',
	'UI-IncidentManagementOverview-IncidentUnassigned' => '尚未分配给办理人的事件',
	'UI:ChangeMgmtMenuOverview:Title' => '变更管理仪表盘',
	'UI-ChangeManagementOverview-ChangeByType' => '按类别划分变更',
	'UI-ChangeManagementOverview-ChangeUnassigned' => '尚未分配给办理人的变更',
	'UI-ChangeManagementOverview-ChangeWithOutage' => '变更引起的停机',
	'UI:ServiceMgmtMenuOverview:Title' => '服务管理仪表盘',
	'UI-ServiceManagementOverview-CustomerContractToRenew' => '客户合同需在30日内更新',
	'UI-ServiceManagementOverview-ProviderContractToRenew' => '供应商合同需在30日内更新',
	'UI:ContactsMenu' => '联系人',
	'UI:ContactsMenu+' => '联系人',
	'UI:ContactsMenu:Title' => '联系人概况',
	'UI-ContactsMenu-ContactsByLocation' => '按地点划分联系人',
	'UI-ContactsMenu-ContactsByType' => '按类别划分联系人',
	'UI-ContactsMenu-ContactsByStatus' => '按状态划分联系人',
	'UI:NotificationsMenu:Title' => '配置通知',
	'UI:NotificationsMenu:Help' => '帮助',
	'UI:NotificationsMenu:HelpContent' => '<p>在'.ITOP_APPLICATION_SHORT.'中, 通知可以被自定义. 它们是基于两个对象集: <i>触发器和操作</i>.</p>
<p><i><b>触发器</b></i>定义了什么时候发送通知. '.ITOP_APPLICATION_SHORT.'内核自带一些触发器, 另一些触发器可由扩展提供:
<ol>
	<li>一些触发器执行于指定类型的对象被<b>创建后</b>, <b>更新后</b>或<b>删除后</b>.</li>
	<li>一些触发器执行于指定类型的对象<b>进入</b>或<b>离开ve</b>指定</b>状态</b>.</li>
	<li>一些触发器执行于<b>TTO阈值或TTR阈值</b>预设值<b>达到时</b>.</li>
</ol>
</p>
<p>
<i><b>操作</b></i>定义触发器执行时要运行的动作. 目前仅支持2类动作:
<ol>
	<li>发送电子邮件: 此动作同时需要指定发送的邮件所使用的模板, 以及一些其他参数, 例如收件人, 优先级, 等.<br />
	这里有一个专用的页面: <a href="../setup/email.test.php" target="_blank">email.test.php</a>可用于测试和调试PHP的邮件配置.</li>
	<li>Sending a newsroom message: Display a news to user directly in the application through the newsroom (bell icon on the left menu)</li>
	<li>外部webhook: 允许通过发送结构化数据到指定URL来与第三方应用集成.</li>
</ol>
</p>
<p>若要执行, 操作必须和触发器相关联.
当与一个触发器关联时, 每个操作都被赋予一个顺序号, 规定了按什么样的顺序执行这些操作.</p>',
	'UI:NotificationsMenu:Triggers' => '触发器',
	'UI:NotificationsMenu:AvailableTriggers' => '可用的触发器',
	'UI:NotificationsMenu:OnCreate' => '当对象被创建',
	'UI:NotificationsMenu:OnStateEnter' => '当对象进入指定状态',
	'UI:NotificationsMenu:OnStateLeave' => '当对象离开指定状态',
	'UI:NotificationsMenu:Actions' => '操作',
	'UI:NotificationsMenu:Actions:ActionEmail' => '邮件操作',
	'UI:NotificationsMenu:Actions:ActionWebhook' => 'Webhook操作 (外部集成)',
	'UI:NotificationsMenu:Actions:Action' => '其它操作',
	'UI:NotificationsMenu:AvailableActions' => '有效的操作',
	'Menu:TagAdminMenu' => '标签配置',
	'Menu:TagAdminMenu+' => '标签值管理',
	'UI:TagAdminMenu:Title' => '标签配置',
	'UI:TagAdminMenu:NoTags' => '未配置标签',
	'UI:TagSetFieldData:Error' => '错误: %1$s',
	'UI:iTopVersion:Short' => '%1$s 版本 %2$s',
	'UI:iTopVersion:Long' => '%1$s 版本 %2$s-%3$s 创建于 %4$s',
	'UI:PropertiesTab' => '属性',
	'UI:OpenDocumentInNewWindow_' => '打开',
	'UI:DownloadDocument_' => '下载',
	'UI:Document:NoPreview' => '此类型文档无法预览',
	'UI:Download-CSV' => '下载 %1$s',
	'UI:DeadlineMissedBy_duration' => '超过 %1$s',
	'UI:Deadline_LessThan1Min' => '< 1分钟',
	'UI:Deadline_Minutes' => '%1$d分钟',
	'UI:Deadline_Hours_Minutes' => '%1$dh %2$dmin',
	'UI:Deadline_Days_Hours_Minutes' => '%1$dd %2$dh %3$dmin',
	'UI:Help' => '帮助',
	'UI:PasswordConfirm' => '确认',
	'UI:BeforeAdding_Class_ObjectsSaveThisObject' => '在添加更多%1$s之前, 请先保存此对象.',
	'UI:DisplayThisMessageAtStartup' => '在启动时显示此消息',
	'UI:RelationshipGraph' => '图形视图',
	'UI:RelationshipList' => '列表视图',
	'UI:RelationGroups' => '组',
	'UI:OperationCancelled' => '操作已取消',
	'UI:ElementsDisplayed' => '筛选',
	'UI:RelationGroupNumber_N' => '分组#%1$d',
	'UI:Relation:ExportAsPDF' => '导出PDF...',
	'UI:RelationOption:GroupingThreshold' => '分组阈值',
	'UI:Relation:AdditionalContextInfo' => '其它信息',
	'UI:Relation:NoneSelected' => '无',
	'UI:Relation:Zoom' => '放大',
	'UI:Relation:ExportAsAttachment' => '导出为附件...',
	'UI:Relation:DrillDown' => '详情...',
	'UI:Relation:PDFExportOptions' => 'PDF导出选项',
	'UI:Relation:AttachmentExportOptions_Name' => '%1$s 附件选项',
	'UI:RelationOption:Untitled' => '无标题',
	'UI:Relation:Key' => '键',
	'UI:Relation:Comments' => '备注',
	'UI:RelationOption:Title' => '标题',
	'UI:RelationOption:IncludeList' => '包含的对象列表',
	'UI:RelationOption:Comments' => '备注',
	'UI:Button:Export' => '导出',
	'UI:Relation:PDFExportPageFormat' => '页面格式',
	'UI:PageFormat_A3' => 'A3',
	'UI:PageFormat_A4' => 'A4',
	'UI:PageFormat_Letter' => '信纸',
	'UI:Relation:PDFExportPageOrientation' => '页面方向',
	'UI:PageOrientation_Portrait' => '纵向',
	'UI:PageOrientation_Landscape' => '横向',
	'UI:RelationTooltip:Redundancy' => '冗余',
	'UI:RelationTooltip:ImpactedItems_N_of_M' => '# 受影响的项目: %1$d / %2$d',
	'UI:RelationTooltip:CriticalThreshold_N_of_M' => '阈值: %1$d / %2$d',
	'Portal:Title' => ITOP_APPLICATION_SHORT.' 用户门户',
	'Portal:NoRequestMgmt' => '亲爱的%1$s, 您被重定向到这个页面, 因为您的账号已被设置成角色 \'Portal user\'. 并且系统没有安装 \'需求管理\' 功能. 请联系管理员.',
	'Portal:Refresh' => '刷新',
	'Portal:Back' => '返回',
	'Portal:WelcomeUserOrg' => '欢迎%1$s, 来自%2$s',
	'Portal:TitleDetailsFor_Request' => '需求详情',
	'Portal:ShowOngoing' => '显示打开的需求',
	'Portal:ShowClosed' => '显示已关闭的需求',
	'Portal:CreateNewRequest' => '新建需求',
	'Portal:CreateNewRequestItil' => '新建需求',
	'Portal:CreateNewIncidentItil' => '新建事件报告',
	'Portal:ChangeMyPassword' => '修改密码',
	'Portal:Disconnect' => '断开',
	'Portal:OpenRequests' => '我打开的需求',
	'Portal:ClosedRequests' => '我已关闭的需求',
	'Portal:ResolvedRequests' => '已解决的需求',
	'Portal:SelectService' => '从类别中选择一项服务:',
	'Portal:PleaseSelectOneService' => '请选择一项服务',
	'Portal:SelectSubcategoryFrom_Service' => '从服务中选择型%1$s:',
	'Portal:PleaseSelectAServiceSubCategory' => '请选择子类型',
	'Portal:DescriptionOfTheRequest' => '请输入描述:',
	'Portal:TitleRequestDetailsFor_Request' => '需求详情%1$s:',
	'Portal:NoOpenRequest' => '此类别中没有打开的需求.',
	'Portal:NoClosedRequest' => '此分类中没有需求',
	'Portal:Button:ReopenTicket' => '重新打开工单',
	'Portal:Button:CloseTicket' => '关闭工单',
	'Portal:Button:UpdateRequest' => '更新需求',
	'Portal:EnterYourCommentsOnTicket' => '请点评此工单的解决方案:',
	'Portal:ErrorNoContactForThisUser' => '错误: 当前用户没有与任何联系人关联. 请联系管理员.',
	'Portal:Attachments' => '附件',
	'Portal:AddAttachment' => ' 添加附件 ',
	'Portal:RemoveAttachment' => ' 移除附件 ',
	'Portal:Attachment_No_To_Ticket_Name' => '添加#%1$d到%2$s (%3$s)',
	'Portal:SelectRequestTemplate' => '请为 %1$s 选择一个模板',
	'Enum:Undefined' => '未定义',
	'UI:DurationForm_Days_Hours_Minutes_Seconds' => '%1$s天%2$s小时%3$s分%4$s秒',
	'UI:ModifyAllPageTitle' => '修改所有',
	'UI:Modify_ObjectsOf_Class' => '修改类型%1$s的对象',
	'UI:Modify_N_ObjectsOf_Class' => '正在修%1$d个%2$s',
	'UI:Modify_M_ObjectsOf_Class_OutOf_N' => '正在修改 %1$d 个 %2$s, 一共 %3$d 个',
	'UI:Menu:ModifyAll' => '修改...',
	'UI:Menu:ModifyAll_Class' => '修改 %1$s 个对象...',
	'UI:Menu:ModifyAll_Link' => '修改 %1$s...',
	'UI:Menu:ModifyAll_Remote' => '修改 %1$s...',
	'UI:Button:ModifyAll' => '全部修改',
	'UI:Button:PreviewModifications' => '修改预览 >>',
	'UI:ModifiedObject' => '对象已修改',
	'UI:BulkModifyStatus' => '操作',
	'UI:BulkModifyStatus+' => '操作状态',
	'UI:BulkModifyErrors' => '报错 (如果有)',
	'UI:BulkModifyErrors+' => '阻止修改时报错',
	'UI:BulkModifyStatusOk' => '正常',
	'UI:BulkModifyStatusError' => '错误',
	'UI:BulkModifyStatusModified' => '已修改',
	'UI:BulkModifyStatusSkipped' => '跳过',
	'UI:BulkModify_Count_DistinctValues' => '%1$d不同的值:',
	'UI:BulkModify:Value_Exists_N_Times' => '%1$s, %2$d 次',
	'UI:BulkModify:N_MoreValues' => '%1$d 个更多值...',
	'UI:AttemptingToSetAReadOnlyAttribute_Name' => '尝试修改只读字段: %1$s',
	'UI:FailedToApplyStimuli' => '操作失败.',
	'UI:StimulusModify_N_ObjectsOf_Class' => '%1$s: 正在修改%2$d个%3$s',
	'UI:CaseLogTypeYourTextHere' => '请在这里输入内容...',
	'UI:CaseLog:Header_Date_UserName' => '%1$s - %2$s:',
	'UI:CaseLog:InitialValue' => '初始值:',
	'UI:AttemptingToSetASlaveAttribute_Name' => '字段%1$s不可写,因为它由数据同步管理. 值未设置.',
	'UI:ActionNotAllowed' => '您无权操作这些对象.',
	'UI:BulkAction:NoObjectSelected' => '请至少选择一个对象进行操作',
	'UI:AttemptingToChangeASlaveAttribute_Name' => '字段%1$s不可写因为其属于数据同步. 值保持未更改.',
	'UI:Pagination:HeaderSelection' => '一共: %1$s 个对象 (已选择 %2$s 个).',
	'UI:Pagination:HeaderNoSelection' => '一共: %1$s 个对象.',
	'UI:Pagination:PageSize' => '每页%1$s个对象',
	'UI:Pagination:PagesLabel' => '页:',
	'UI:Pagination:All' => '全部',
	'UI:HierarchyOf_Class' => '%1$s层级',
	'UI:Preferences' => '首选项...',
	'UI:ArchiveModeOn' => '激活归档模式',
	'UI:ArchiveModeOff' => '关闭归档模式',
	'UI:ArchiveMode:Banner' => '归档模式',
	'UI:ArchiveMode:Banner+' => '已归档的对象可见但不允许修改',
	'UI:FavoriteOrganizations' => '快速访问',
	'UI:FavoriteOrganizations+' => '进入组织下的列表,可实现通过下拉菜单快速访问. 请注意,这并不是一个安全设置, 其它组织的对象依然可以通过选择 "所有组织" 下拉列表看到.',
	'UI:FavoriteLanguage' => '语言',
	'UI:Favorites:SelectYourLanguage' => '选择语言',
	'UI:FavoriteOtherSettings' => '其它设置',
	'UI:Favorites:Default_X_ItemsPerPage' => '默认行数: 每页%1$s个项目',
	'UI:Favorites:ShowObsoleteData' => '显示废弃的数据',
	'UI:Favorites:ShowObsoleteData+' => '在搜索结果中显示已废弃的数据',
	'UI:NavigateAwayConfirmationMessage' => '所有修改都将丢失.',
	'UI:CancelConfirmationMessage' => '您将丢失所有修改. 是否继续?',
	'UI:AutoApplyConfirmationMessage' => '有些修改尚未生效. 您希望这些更改生效吗?',
	'UI:Create_Class_InState' => '创建对象%1$s并设置状态: ',
	'UI:OrderByHint_Values' => '排序: %1$s',
	'UI:Menu:AddToDashboard' => '添加到仪表盘...',
	'UI:Button:Refresh' => '刷新',
	'UI:Button:GoPrint' => '打印...',
	'UI:ExplainPrintable' => '点击 %1$s 图标可隐藏打印内容.<br/>在打印之前可使用浏览器的 "打印预览" 功能.<br/>注: 这个页首和其它控制面板不会被打印.',
	'UI:PrintResolution:FullSize' => '全尺寸',
	'UI:PrintResolution:A4Portrait' => 'A4 纵向',
	'UI:PrintResolution:A4Landscape' => 'A4 横向',
	'UI:PrintResolution:LetterPortrait' => '纵向信纸',
	'UI:PrintResolution:LetterLandscape' => '横向信纸',
	'UI:Toggle:SwitchToStandardDashboard' => '切换到标准仪表盘',
	'UI:Toggle:SwitchToCustomDashboard' => '切换到自定义仪表盘',
	'UI:ConfigureThisList' => '配置列表...',
	'UI:ListConfigurationTitle' => '列表配置',
	'UI:ColumnsAndSortOrder' => '列和排序顺序:',
	'UI:UseDefaultSettings' => '使用默认配置',
	'UI:UseSpecificSettings' => '使用下面的配置:',
	'UI:Display_X_ItemsPerPage_prefix' => '每页显示',
	'UI:Display_X_ItemsPerPage_suffix' => '个项目',
	'UI:UseSavetheSettings' => '保存设置',
	'UI:OnlyForThisList' => '仅这个列表',
	'UI:ForAllLists' => '默认所有列表',
	'UI:ExtKey_AsLink' => '%1$s (超链接)',
	'UI:ExtKey_AsFriendlyName' => '%1$s (昵称)',
	'UI:ExtField_AsRemoteField' => '%1$s (%2$s)',
	'UI:Button:MoveUp' => '上移',
	'UI:Button:MoveDown' => '下移',
	'UI:OQL:UnknownClassAndFix' => '未知类型 "%1$s". 您可以试试 "%2$s".',
	'UI:OQL:UnknownClassNoFix' => '未知类型 "%1$s"',
	'UI:Dashboard:EditCustom' => '编辑自定义版本...',
	'UI:Dashboard:CreateCustom' => '新建自定义版本...',
	'UI:Dashboard:DeleteCustom' => '删除自定义版本...',
	'UI:Dashboard:Edit' => '编辑这个页面...',
	'UI:Dashboard:RevertConfirm' => '每个地方都会恢复到初始版本. 请确认您要这样做.',
	'UI:ExportDashBoard' => '导出到文件',
	'UI:ImportDashBoard' => '从文件导入...',
	'UI:ImportDashboardTitle' => '从文件导入',
	'UI:ImportDashboardText' => '选择要导入的仪表盘文件:',
	'UI:Dashboard:Actions' => '仪表盘操作',
	'UI:Dashboard:NotUpToDateUntilContainerSaved' => '此仪表盘显示的信息不包含后续的更新.',
	'UI:Dashboard:Revert' => '还原到初始版本...',
	'UI:DashletCreation:Title' => '新建组件',
	'UI:DashletCreation:Dashboard' => '仪表盘',
	'UI:DashletCreation:DashletType' => '组件类型',
	'UI:DashletCreation:EditNow' => '编辑仪表盘',
	'UI:DashboardEdit:Title' => '仪表盘编辑器',
	'UI:DashboardEdit:DashboardTitle' => '标题',
	'UI:DashboardEdit:AutoReload' => '自动刷新',
	'UI:DashboardEdit:AutoReloadSec' => '自动刷新间隔 (秒)',
	'UI:DashboardEdit:AutoReloadSec+' => '最小值是 %1$d 秒',
	'UI:DashboardEdit:Revert' => '撤回',
	'UI:DashboardEdit:Apply' => '应用',
	'UI:DashboardEdit:Layout' => '布局',
	'UI:DashboardEdit:Properties' => '仪表盘属性',
	'UI:DashboardEdit:Dashlets' => '可用的组件',
	'UI:DashboardEdit:DashletProperties' => '组件属性',
	'UI:Form:Property' => '属性',
	'UI:Form:Value' => '值',
	'UI:DashletUnknown:Label' => '未知',
	'UI:DashletUnknown:Description' => '未知仪表盘 (可能已卸载)',
	'UI:DashletUnknown:RenderText:View' => '此仪表盘无法渲染.',
	'UI:DashletUnknown:RenderText:Edit' => '此仪表盘无法渲染 (类型 "%1$s"). 请与管理员确认其可用.',
	'UI:DashletUnknown:RenderNoDataText:Edit' => '此仪表盘无预览 (类型 "%1$s").',
	'UI:DashletUnknown:Prop-XMLConfiguration' => '配置 (显示为纯 XML)',
	'UI:DashletProxy:Label' => '代理',
	'UI:DashletProxy:Description' => '代理仪表盘',
	'UI:DashletProxy:RenderNoDataText:Edit' => '第三方组件无法预览 (类型 "%1$s").',
	'UI:DashletProxy:Prop-XMLConfiguration' => '配置 (显示为纯 XML)',
	'UI:DashletPlainText:Label' => '文本',
	'UI:DashletPlainText:Description' => '纯文本 (无格式)',
	'UI:DashletPlainText:Prop-Text' => '内容',
	'UI:DashletPlainText:Prop-Text:Default' => '请在这里输入内容...',
	'UI:DashletObjectList:Label' => '对象列表',
	'UI:DashletObjectList:Description' => '对象列表仪表盘',
	'UI:DashletObjectList:Prop-Title' => '标题',
	'UI:DashletObjectList:Prop-Query' => '查询',
	'UI:DashletObjectList:Prop-Menu' => '菜单',
	'UI:DashletGroupBy:Prop-Title' => '标题',
	'UI:DashletGroupBy:Prop-Query' => '查询',
	'UI:DashletGroupBy:Prop-Style' => '样式',
	'UI:DashletGroupBy:Prop-GroupBy' => '分组...',
	'UI:DashletGroupBy:Prop-GroupBy:Hour' => '%1$s 小时数(0-23)',
	'UI:DashletGroupBy:Prop-GroupBy:Month' => '%1$s 月份(1-12)',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfWeek' => '%1$s 星期数',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfMonth' => '%1$s月天数',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Hour' => '%1$s (小时)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Month' => '%1$s (月)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfWeek' => '%1$s (星期数)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfMonth' => '%1$s (月天数)',
	'UI:DashletGroupBy:MissingGroupBy' => '请选择对象的分组字段',
	'UI:DashletGroupByPie:Label' => '饼图',
	'UI:DashletGroupByPie:Description' => '饼图',
	'UI:DashletGroupByBars:Label' => '柱状图',
	'UI:DashletGroupByBars:Description' => '柱状图',
	'UI:DashletGroupByTable:Label' => '分组 (表)',
	'UI:DashletGroupByTable:Description' => '列表 (以字段分组)',
	'UI:DashletGroupBy:Prop-Function' => '聚合函数',
	'UI:DashletGroupBy:Prop-FunctionAttribute' => '函数属性',
	'UI:DashletGroupBy:Prop-OrderDirection' => '方向',
	'UI:DashletGroupBy:Prop-OrderField' => '排序',
	'UI:DashletGroupBy:Prop-Limit' => '限制',
	'UI:DashletGroupBy:Order:asc' => '升序',
	'UI:DashletGroupBy:Order:desc' => '降序',
	'UI:GroupBy:count' => '个数',
	'UI:GroupBy:count+' => '项目数',
	'UI:GroupBy:sum' => '总数',
	'UI:GroupBy:sum+' => '%1$s 之和',
	'UI:GroupBy:avg' => '平均',
	'UI:GroupBy:avg+' => '%1$s 平均值',
	'UI:GroupBy:min' => '最小',
	'UI:GroupBy:min+' => '%1$s 最小值',
	'UI:GroupBy:max' => '最大',
	'UI:GroupBy:max+' => '%1$s 最大值',
	'UI:DashletHeaderStatic:Label' => '标头',
	'UI:DashletHeaderStatic:Description' => '显示水平分隔符',
	'UI:DashletHeaderStatic:Prop-Title' => '标题',
	'UI:DashletHeaderStatic:Prop-Title:Default' => '联系人',
	'UI:DashletHeaderStatic:Prop-Icon' => '图标',
	'UI:DashletHeaderDynamic:Label' => '统计标头',
	'UI:DashletHeaderDynamic:Description' => '统计标头 (分组...)',
	'UI:DashletHeaderDynamic:Prop-Title' => '标题',
	'UI:DashletHeaderDynamic:Prop-Title:Default' => '联系人',
	'UI:DashletHeaderDynamic:Prop-Icon' => '图标',
	'UI:DashletHeaderDynamic:Prop-Subtitle' => '副标题',
	'UI:DashletHeaderDynamic:Prop-Subtitle:Default' => '联系人',
	'UI:DashletHeaderDynamic:Prop-Query' => '查询',
	'UI:DashletHeaderDynamic:Prop-GroupBy' => '分组依据',
	'UI:DashletHeaderDynamic:Prop-Values' => '值',
	'UI:DashletBadge:Label' => '证件',
	'UI:DashletBadge:Description' => '新建/查询的对象图标',
	'UI:DashletBadge:Prop-Class' => '类型',
	'DayOfWeek-Sunday' => '周日',
	'DayOfWeek-Monday' => '周一',
	'DayOfWeek-Tuesday' => '周二',
	'DayOfWeek-Wednesday' => '周三',
	'DayOfWeek-Thursday' => '周四',
	'DayOfWeek-Friday' => '周五',
	'DayOfWeek-Saturday' => '周六',
	'Month-01' => '一月',
	'Month-02' => '二月',
	'Month-03' => '三月',
	'Month-04' => '四月',
	'Month-05' => '五月',
	'Month-06' => '六月',
	'Month-07' => '七月',
	'Month-08' => '八月',
	'Month-09' => '九月',
	'Month-10' => '十月',
	'Month-11' => '十一月',
	'Month-12' => '十二月',
	'DayOfWeek-Sunday-Min' => '日',
	'DayOfWeek-Monday-Min' => '一',
	'DayOfWeek-Tuesday-Min' => '二',
	'DayOfWeek-Wednesday-Min' => '三',
	'DayOfWeek-Thursday-Min' => '四',
	'DayOfWeek-Friday-Min' => '五',
	'DayOfWeek-Saturday-Min' => '六',
	'Month-01-Short' => '1月',
	'Month-02-Short' => '2月',
	'Month-03-Short' => '3月',
	'Month-04-Short' => '4月',
	'Month-05-Short' => '5月',
	'Month-06-Short' => '6月',
	'Month-07-Short' => '7月',
	'Month-08-Short' => '8月',
	'Month-09-Short' => '9月',
	'Month-10-Short' => '10月',
	'Month-11-Short' => '11月',
	'Month-12-Short' => '12月',
	'Calendar-FirstDayOfWeek' => '0',
	'UI:Menu:ShortcutList' => '创建快捷方式...',
	'UI:Menu:FilterList' => '显示条件查询列表',
	'UI:ShortcutRenameDlg:Title' => '重命名快捷方式',
	'UI:ShortcutListDlg:Title' => '为此列表创建快捷方式',
	'UI:ShortcutDelete:Confirm' => '请确认是否删除该快捷方式.',
	'UI:ObjectShortcutInsert' => '插入对象的快捷方式',
	'Class:Shortcut' => '快捷方式',
	'Class:Shortcut+' => '',
	'Class:Shortcut/Attribute:name' => '名称',
	'Class:Shortcut/Attribute:name+' => '用于菜单和页面的标记',
	'Class:ShortcutOQL' => '搜索结果的快捷方式',
	'Class:ShortcutOQL+' => '',
	'Class:ShortcutOQL/Attribute:oql' => '查询',
	'Class:ShortcutOQL/Attribute:oql+' => '定义执行搜索的对象列表的OQL',
	'Class:TagSetFieldData/Attribute:finalclass' => '标签类型',
	'Class:TagSetFieldData/Attribute:obj_attcode' => '字段编码',
	'Class:TagSetFieldData/Attribute:obj_class' => '对象类型',
	'Class:ShortcutOQL/Attribute:auto_reload' => '自动刷新',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:none' => '禁用',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:custom' => '自定义频率',
	'Class:ShortcutOQL/Attribute:auto_reload_sec' => '自动刷新间隔 (秒)',
	'Class:ShortcutOQL/Attribute:auto_reload_sec/tip' => '最小值是 %1$d 秒',
	'UI:FillAllMandatoryFields' => '请填写所有的必填项.',
	'UI:ValueMustBeSet' => '必填',
	'UI:ValueMustBeChanged' => '必须修改这个值',
	'UI:ValueInvalidFormat' => '格式无效',
	'UI:CSVImportConfirmTitle' => '请确认本次操作',
	'UI:CSVImportConfirmMessage' => '请确认是否继续?',
	'UI:CSVImportError_items' => '错误: %1$d',
	'UI:CSVImportCreated_items' => '创建: %1$d',
	'UI:CSVImportModified_items' => '修改: %1$d',
	'UI:CSVImportUnchanged_items' => '保持不变: %1$d',
	'UI:CSVImport:DateAndTimeFormats' => '日期和时间格式',
	'UI:CSVImport:DefaultDateTimeFormat_Format_Example' => '默认格式: %1$s (比如 %2$s)',
	'UI:CSVImport:CustomDateTimeFormat' => '自定义格式: %1$s',
	'UI:CSVImport:CustomDateTimeFormatTooltip' => '可用的值:<table>
<tr><td>Y</td><td>年 (4位数, 比如 2016)</td></tr>
<tr><td>y</td><td>年 (2位数, 比如 16 代表 2016)</td></tr>
<tr><td>m</td><td>月 (2位数, 比如 01..12)</td></tr>
<tr><td>n</td><td>月 (1位数或2位数, 比如 1..12)</td></tr>
<tr><td>d</td><td>日 (2位数, 比如 01..31)</td></tr>
<tr><td>j</td><td>日 (1位数或2位数, 比如 1..31)</td></tr>
<tr><td>H</td><td>时 (24小时, 2位数, 比如 00..23)</td></tr>
<tr><td>h</td><td>时 (12小时, 2位数, 比如 01..12)</td></tr>
<tr><td>G</td><td>时 (24小时, 1位数或2位数, 比如 0..23)</td></tr>
<tr><td>g</td><td>时 (12小时, 1位数或2位数, 比如 1..12)</td></tr>
<tr><td>a</td><td>时, am or pm (小写)</td></tr>
<tr><td>A</td><td>时, AM or PM (大写)</td></tr>
<tr><td>i</td><td>分 (2位数, 比如 00..59)</td></tr>
<tr><td>s</td><td>秒 (2位数, 比如 00..59)</td></tr>
</table>',
	'UI:Button:Remove' => '移除',
	'UI:AddAnExisting_Class' => '添加 %1$s...',
	'UI:SelectionOf_Class' => '选择 %1$s',
	'UI:AboutBox' => '关于'.ITOP_APPLICATION_SHORT.'...',
	'UI:About:Title' => '关于'.ITOP_APPLICATION_SHORT, 'UI:About:DataModel' => '数据模型',
	'UI:About:Support' => '支持信息',
	'UI:About:Licenses' => '许可证',
	'UI:About:InstallationOptions' => '已安装的模块',
	'UI:About:ManualExtensionSource' => '扩展',
	'UI:About:Extension_Version' => '版本: %1$s',
	'UI:About:RemoteExtensionSource' => '数据',
	'UI:DisconnectedDlgMessage' => '您已断开. 要继续使用,需要重新验证您的用户名和密码.',
	'UI:DisconnectedDlgTitle' => '警告!',
	'UI:LoginAgain' => '再次登录',
	'UI:StayOnThePage' => '保持在当前页面',
	'ExcelExporter:ExportMenu' => 'Excel 导出...',
	'ExcelExporter:ExportDialogTitle' => 'Excel 导出',
	'ExcelExporter:ExportButton' => '导出',
	'ExcelExporter:DownloadButton' => '下载 %1$s',
	'ExcelExporter:RetrievingData' => '正在检索数据...',
	'ExcelExporter:BuildingExcelFile' => '正在创建 Excel 文件...',
	'ExcelExporter:Done' => '完成.',
	'ExcelExport:AutoDownload' => '导出准备好之后自动开始下载',
	'ExcelExport:PreparingExport' => '正在准备导出...',
	'ExcelExport:Statistics' => '状态',
	'portal:legacy_portal' => '终端用户门户',
	'portal:backoffice' => ITOP_APPLICATION_SHORT.'后台用户界面',
	'UI:CurrentObjectIsLockedBy_User' => '对象被锁定, 因为正在修改%1$s.',
	'UI:CurrentObjectIsLockedBy_User_Explanation' => '此对象正在被%1$s修改. 您的修改无法提交以避免冲突.',
	'UI:CurrentObjectIsSoftLockedBy_User' => '此对象当前正在被%1$s修改. 在其修改结束后您将能提交您的修改.',
	'UI:CurrentObjectLockExpired' => '并发修改的锁定期已过.',
	'UI:CurrentObjectLockExpired_Explanation' => '防止对象被并发修改的锁定已失效. 其他用户已允许修改当前对象因此您不能再提交您的修改.',
	'UI:ConcurrentLockKilled' => '阻止并发修改当前对象的锁定已被删除.',
	'UI:Menu:KillConcurrentLock' => '消除并发修改锁定!',
	'UI:Menu:ExportPDF' => '导出PDF...',
	'UI:Menu:PrintableVersion' => '打印',
	'UI:BrowseInlineImages' => '浏览图片...',
	'UI:UploadInlineImageLegend' => '上传新图片',
	'UI:SelectInlineImageToUpload' => '选择要上传的图片',
	'UI:AvailableInlineImagesLegend' => '可用的图片',
	'UI:NoInlineImage' => '服务器上没有图片. 使用上面的 "浏览" 按钮, 从您的电脑上选择并上传到服务器.',
	'UI:ToggleFullScreen' => '切换最大化/最小化',
	'UI:Button:ResetImage' => '恢复之前的图片',
	'UI:Button:RemoveImage' => '移除图片',
	'UI:Button:UploadImage' => '从硬盘上传图像',
	'UI:UploadNotSupportedInThisMode' => '本模式下不支持修改文件或图片.',
	'UI:Button:RemoveDocument' => '移除文档',
	'UI:Search:Toggle' => '折叠/展开',
	'UI:Search:AutoSubmit:DisabledHint' => '此类别已禁用自动提交',
	'UI:Search:Obsolescence:DisabledHint' => '根据您的设置, 废弃的数据会被隐藏',
	'UI:Search:NoAutoSubmit:ExplainText' => '在搜索框中添加规则, 或者单击对象按钮查看对象.',
	'UI:Search:Criterion:MoreMenu:AddCriteria' => '添加条件',
	'UI:Search:AddCriteria:List:RecentlyUsed:Title' => '最近使用',
	'UI:Search:AddCriteria:List:MostPopular:Title' => '最常用',
	'UI:Search:AddCriteria:List:Others:Title' => '其它',
	'UI:Search:AddCriteria:List:RecentlyUsed:Placeholder' => '还没有.',
	'UI:Search:Criteria:Toggle' => '折叠/展开',
	'UI:Search:Criteria:Remove' => '移除',
	'UI:Search:Criteria:Locked' => '已锁定',
	'UI:Search:Criteria:Title:Default:Any' => '%1$s: 任何',
	'UI:Search:Criteria:Title:Default:Empty' => '%1$s 为空',
	'UI:Search:Criteria:Title:Default:NotEmpty' => '%1$s 不为空',
	'UI:Search:Criteria:Title:Default:Equals' => '%1$s 等于 %2$s',
	'UI:Search:Criteria:Title:Default:Contains' => '%1$s 包含 %2$s',
	'UI:Search:Criteria:Title:Default:StartsWith' => '%1$s 起始于 %2$s',
	'UI:Search:Criteria:Title:Default:EndsWith' => '%1$s 结尾是 %2$s',
	'UI:Search:Criteria:Title:Default:RegExp' => '%1$s 匹配 %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThan' => '%1$s > %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThanOrEquals' => '%1$s >= %2$s',
	'UI:Search:Criteria:Title:Default:LessThan' => '%1$s < %2$s',
	'UI:Search:Criteria:Title:Default:LessThanOrEquals' => '%1$s <= %2$s',
	'UI:Search:Criteria:Title:Default:Different' => '%1$s ≠ %2$s',
	'UI:Search:Criteria:Title:Default:Between' => '%1$s between [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates' => '%1$s [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates:All' => '%1$s: 任何',
	'UI:Search:Criteria:Title:Default:BetweenDates:From' => '%1$s 从 %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates:Until' => '%1$s 到 %2$s',
	'UI:Search:Criteria:Title:Default:Between:All' => '%1$s: 任何',
	'UI:Search:Criteria:Title:Default:Between:From' => '%1$s 从 %2$s',
	'UI:Search:Criteria:Title:Default:Between:Until' => '%1$s 到 %2$s',
	'UI:Search:Criteria:Title:DateTime:Between' => '%2$s <= 1$s <= %3$s',
	'UI:Search:Criteria:Title:Enum:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:Enum:In:Many' => '%1$s: %2$s 和 %3$s 其他',
	'UI:Search:Criteria:Title:Enum:In:All' => '%1$s: 任何',
	'UI:Search:Criteria:Title:TagSet:Matches' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:ExternalKey:Empty' => '%1$s 已定义',
	'UI:Search:Criteria:Title:ExternalKey:NotEmpty' => '%1$s 未定义',
	'UI:Search:Criteria:Title:ExternalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In:Many' => '%1$s: %2$s 和 %3$s 其他',
	'UI:Search:Criteria:Title:ExternalKey:In:All' => '%1$s: 任何',
	'UI:Search:Criteria:Title:HierarchicalKey:Empty' => '%1$s 已定义',
	'UI:Search:Criteria:Title:HierarchicalKey:NotEmpty' => '%1$s 未定义',
	'UI:Search:Criteria:Title:HierarchicalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In:Many' => '%1$s: %2$s 和 %3$s 其他',
	'UI:Search:Criteria:Title:HierarchicalKey:In:All' => '%1$s: 任何',
	'UI:Search:Criteria:Operator:Default:Empty' => '为空',
	'UI:Search:Criteria:Operator:Default:NotEmpty' => '非空',
	'UI:Search:Criteria:Operator:Default:Equals' => '等于',
	'UI:Search:Criteria:Operator:Default:Between' => '之间',
	'UI:Search:Criteria:Operator:String:Contains' => '包含',
	'UI:Search:Criteria:Operator:String:StartsWith' => '起始为',
	'UI:Search:Criteria:Operator:String:EndsWith' => '结尾是',
	'UI:Search:Criteria:Operator:String:RegExp' => '正则表达式.',
	'UI:Search:Criteria:Operator:Numeric:Equals' => '等于',
	'UI:Search:Criteria:Operator:Numeric:GreaterThan' => '大于',
	'UI:Search:Criteria:Operator:Numeric:GreaterThanOrEquals' => '大于/等于',
	'UI:Search:Criteria:Operator:Numeric:LessThan' => '小于',
	'UI:Search:Criteria:Operator:Numeric:LessThanOrEquals' => '小于/等于',
	'UI:Search:Criteria:Operator:Numeric:Different' => '不同',
	'UI:Search:Criteria:Operator:TagSet:Matches' => '匹配',
	'UI:Search:Value:Filter:Placeholder' => '筛选器...',
	'UI:Search:Value:Search:Placeholder' => '搜索...',
	'UI:Search:Value:Autocomplete:StartTyping' => '开始输入值.',
	'UI:Search:Value:Autocomplete:Wait' => '请稍候...',
	'UI:Search:Value:Autocomplete:NoResult' => '没有找到结果.',
	'UI:Search:Value:Toggler:CheckAllNone' => '全选/不选',
	'UI:Search:Value:Toggler:CheckAllNoneFiltered' => '全选/不选',
	'UI:Search:Criteria:Numeric:From' => '从',
	'UI:Search:Criteria:Numeric:Until' => '到',
	'UI:Search:Criteria:Numeric:PlaceholderFrom' => '任何',
	'UI:Search:Criteria:Numeric:PlaceholderUntil' => '任何',
	'UI:Search:Criteria:DateTime:From' => '从',
	'UI:Search:Criteria:DateTime:FromTime' => '从',
	'UI:Search:Criteria:DateTime:Until' => '到',
	'UI:Search:Criteria:DateTime:UntilTime' => '到',
	'UI:Search:Criteria:DateTime:PlaceholderFrom' => '任何日期',
	'UI:Search:Criteria:DateTime:PlaceholderFromTime' => '任何日期',
	'UI:Search:Criteria:DateTime:PlaceholderUntil' => '任何日期',
	'UI:Search:Criteria:DateTime:PlaceholderUntilTime' => '任何日期',
	'UI:Search:Criteria:HierarchicalKey:ChildrenIncluded:Hint' => '将会包含选中对象的子集.',
	'UI:Search:Criteria:Raw:Filtered' => '已筛选',
	'UI:Search:Criteria:Raw:FilteredOn' => '基于%1$s筛选',
	'UI:StateChanged' => '状态已改变'
));

//
// Expression to Natural language
//
Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Expression:Operator:AND' => ' 与 ',
	'Expression:Operator:OR' => ' 或 ',
	'Expression:Operator:=' => ': ',
	'Expression:Unit:Short:DAY' => '日',
	'Expression:Unit:Short:WEEK' => '周',
	'Expression:Unit:Short:MONTH' => '月',
	'Expression:Unit:Short:YEAR' => '年',
	'Expression:Unit:Long:DAY' => '日',
	'Expression:Unit:Long:HOUR' => '小时',
	'Expression:Unit:Long:MINUTE' => '分钟',
	'Expression:Verb:NOW' => '现在',
	'Expression:Verb:ISNULL' => ': 未定义',
));

//
// iTop Newsroom menu
//
Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'UI:Newsroom:NoNewMessage' => '没有新消息',
	'UI:Newsroom:XNewMessage' => '%1$s 条新消息',
	'UI:Newsroom:MarkAllAsRead' => '标记所有消息为已读',
	'UI:Newsroom:ViewAllMessages' => '查看全部消息',
	'UI:Newsroom:Preferences' => '消息选项',
	'UI:Newsroom:ConfigurationLink' => '配置',
	'UI:Newsroom:ResetCache' => '刷新缓存',
	'UI:Newsroom:ResetCache:Success:Message' => '缓存已成功清除',
	'UI:Newsroom:DisplayMessagesFor_Provider' => '显示来自%1$s的消息',
	'UI:Newsroom:DisplayAtMost_X_Messages' => '在 %2$s 菜单中最多显示 %1$s 条消息.',
	'UI:Newsroom:Priority:1:Tooltip' => '严重',
	'UI:Newsroom:Priority:2:Tooltip' => '紧急',
	'UI:Newsroom:Priority:3:Tooltip' => '重要',
	'UI:Newsroom:Priority:4:Tooltip' => '普通',
));


Dict::Add('ZH CN', 'Chinese', '简体中文', array(
	'Menu:DataSources' => '同步数据源',
	'Menu:DataSources+' => '所有同步数据源',
	'Menu:AuditCategories' => '审计类别',
	'Menu:AuditCategories+' => '审计类别',
	'Menu:AuditCategories:Title' => '审计设置',
	'Menu:RunQueriesMenu' => '运行查询',
	'Menu:RunQueriesMenu+' => '运行任何查询',
	'Menu:QueryMenu' => '预定义查询',
	'Menu:QueryMenu+' => '可重复利用的查询语句',
	'Menu:UniversalSearchMenu' => '全局搜索',
	'Menu:UniversalSearchMenu+' => '搜索所有...',
	'Menu:UserManagementMenu' => '用户管理',
	'Menu:UserManagementMenu+' => '谁可以访问'.ITOP_APPLICATION_SHORT.'以及可以做什么?',
	'Menu:ProfilesMenu' => '角色',
	'Menu:ProfilesMenu+' => '查看已有的角色',
	'Menu:ProfilesMenu:Title' => '角色',
	'Menu:UserAccountsMenu' => '用户账号',
	'Menu:UserAccountsMenu+' => '处理 '.ITOP_APPLICATION_SHORT.' 用户及权限',
	'Menu:UserAccountsMenu:Title' => '用户账号',
	'Menu:UserManagement' => '用户管理',
	'Menu:Queries' => '查询',
	'Menu:ConfigurationTools' => '配置',
	'Menu:ConfigEditor' => '基本配置',
	'Menu:ConfigEditor+' => '配置文件编辑器',
	'Menu:Integrations' => '集成',
	'Menu:Integrations+' => '~~',

));
