<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 * @author Lukáš Dvořák <lukas.dvorak@itopportal.cz>
 * @author Daniel Rokos <daniel.rokos@itopportal.cz>
 *
 */
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:Ticket' => 'Tiket',
	'Class:Ticket+' => '',
	'Class:Ticket/Attribute:ref' => 'ID',
	'Class:Ticket/Attribute:ref+' => '',
	'Class:Ticket/Attribute:org_id' => 'Organizace',
	'Class:Ticket/Attribute:org_id+' => '',
	'Class:Ticket/Attribute:org_name' => 'Název organizace',
	'Class:Ticket/Attribute:org_name+' => '',
	'Class:Ticket/Attribute:caller_id' => 'Zadavatel',
	'Class:Ticket/Attribute:caller_id+' => '',
	'Class:Ticket/Attribute:caller_name' => 'Název zadavatele',
	'Class:Ticket/Attribute:caller_name+' => '',
	'Class:Ticket/Attribute:team_id' => 'Tým',
	'Class:Ticket/Attribute:team_id+' => '',
	'Class:Ticket/Attribute:team_name' => 'Název týmu',
	'Class:Ticket/Attribute:team_name+' => '',
	'Class:Ticket/Attribute:agent_id' => 'Řešitel',
	'Class:Ticket/Attribute:agent_id+' => '',
	'Class:Ticket/Attribute:agent_name' => 'Název řešitele',
	'Class:Ticket/Attribute:agent_name+' => '',
	'Class:Ticket/Attribute:title' => 'Název',
	'Class:Ticket/Attribute:title+' => '',
	'Class:Ticket/Attribute:description' => 'Popis',
	'Class:Ticket/Attribute:description+' => '',
	'Class:Ticket/Attribute:start_date' => 'Datum vytvoření',
	'Class:Ticket/Attribute:start_date+' => '',
	'Class:Ticket/Attribute:end_date' => 'Datum ukončení',
	'Class:Ticket/Attribute:end_date+' => '',
	'Class:Ticket/Attribute:last_update' => 'Poslední aktualizace',
	'Class:Ticket/Attribute:last_update+' => '',
	'Class:Ticket/Attribute:close_date' => 'Datum uzavření',
	'Class:Ticket/Attribute:close_date+' => '',
	'Class:Ticket/Attribute:private_log' => 'Interní záznam',
	'Class:Ticket/Attribute:private_log+' => '',
	'Class:Ticket/Attribute:contacts_list' => 'Kontakty',
	'Class:Ticket/Attribute:contacts_list+' => 'Všechny kontakty spojené s tímto tiketem',
	'Class:Ticket/Attribute:functionalcis_list' => 'Konfigurační položky',
	'Class:Ticket/Attribute:functionalcis_list+' => 'Všechny konfigurační položky ovlivněné tímto tiketem',
	'Class:Ticket/Attribute:workorders_list' => 'Pracovní příkazy',
	'Class:Ticket/Attribute:workorders_list+' => 'Všechny pracovní příkazy pro tento tiket',
	'Class:Ticket/Attribute:finalclass' => 'Typ',
	'Class:Ticket/Attribute:finalclass+' => '',
	'Class:Ticket/Attribute:operational_status' => 'Provozní stav',
	'Class:Ticket/Attribute:operational_status+' => 'Vypočítán z podrobného stavu',
	'Class:Ticket/Attribute:operational_status/Value:ongoing' => 'Probíhající',
	'Class:Ticket/Attribute:operational_status/Value:ongoing+' => '',
	'Class:Ticket/Attribute:operational_status/Value:resolved' => 'Vyřešený',
	'Class:Ticket/Attribute:operational_status/Value:resolved+' => '',
	'Class:Ticket/Attribute:operational_status/Value:closed' => 'Uzavřený',
	'Class:Ticket/Attribute:operational_status/Value:closed+' => '',
	'Ticket:ImpactAnalysis' => 'Analýza dopadů',
));


//
// Class: lnkContactToTicket
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:lnkContactToTicket' => 'Spojení (Kontakt / Tiket)',
	'Class:lnkContactToTicket+' => '',
	'Class:lnkContactToTicket/Name' => '%1$s / %2$s~~',
	'Class:lnkContactToTicket/Attribute:ticket_id' => 'Tiket',
	'Class:lnkContactToTicket/Attribute:ticket_id+' => '',
	'Class:lnkContactToTicket/Attribute:ticket_ref' => 'ID',
	'Class:lnkContactToTicket/Attribute:ticket_ref+' => '',
	'Class:lnkContactToTicket/Attribute:contact_id' => 'Kontakt',
	'Class:lnkContactToTicket/Attribute:contact_id+' => '',
	'Class:lnkContactToTicket/Attribute:contact_name' => 'Jméno kontaktu',
	'Class:lnkContactToTicket/Attribute:contact_name+' => '~~',
	'Class:lnkContactToTicket/Attribute:contact_email' => 'Email kontaktu',
	'Class:lnkContactToTicket/Attribute:contact_email+' => '',
	'Class:lnkContactToTicket/Attribute:role' => 'Role (text)',
	'Class:lnkContactToTicket/Attribute:role+' => '',
	'Class:lnkContactToTicket/Attribute:role_code' => 'Role',
	'Class:lnkContactToTicket/Attribute:role_code/Value:manual' => 'Přidán manuálně',
	'Class:lnkContactToTicket/Attribute:role_code/Value:computed' => 'Automaticky',
	'Class:lnkContactToTicket/Attribute:role_code/Value:do_not_notify' => 'Neupozorňovat',
));

//
// Class: WorkOrder
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:WorkOrder' => 'Pracovní příkaz',
	'Class:WorkOrder+' => '',
	'Class:WorkOrder/Attribute:name' => 'Název',
	'Class:WorkOrder/Attribute:name+' => '',
	'Class:WorkOrder/Attribute:status' => 'Stav',
	'Class:WorkOrder/Attribute:status+' => '',
	'Class:WorkOrder/Attribute:status/Value:open' => 'otevřený',
	'Class:WorkOrder/Attribute:status/Value:open+' => '',
	'Class:WorkOrder/Attribute:status/Value:closed' => 'uzavřený',
	'Class:WorkOrder/Attribute:status/Value:closed+' => '',
	'Class:WorkOrder/Attribute:description' => 'Popis',
	'Class:WorkOrder/Attribute:description+' => '',
	'Class:WorkOrder/Attribute:ticket_id' => 'Tiket',
	'Class:WorkOrder/Attribute:ticket_id+' => '',
	'Class:WorkOrder/Attribute:ticket_ref' => 'ID tiketu',
	'Class:WorkOrder/Attribute:ticket_ref+' => '',
	'Class:WorkOrder/Attribute:team_id' => 'Tým',
	'Class:WorkOrder/Attribute:team_id+' => '',
	'Class:WorkOrder/Attribute:team_name' => 'Název týmu',
	'Class:WorkOrder/Attribute:team_name+' => '',
	'Class:WorkOrder/Attribute:agent_id' => 'Řešitel',
	'Class:WorkOrder/Attribute:agent_id+' => '',
	'Class:WorkOrder/Attribute:agent_email' => 'Email řešitele',
	'Class:WorkOrder/Attribute:agent_email+' => '',
	'Class:WorkOrder/Attribute:start_date' => 'Datum začátku',
	'Class:WorkOrder/Attribute:start_date+' => '',
	'Class:WorkOrder/Attribute:end_date' => 'Datum konce',
	'Class:WorkOrder/Attribute:end_date+' => '',
	'Class:WorkOrder/Attribute:log' => 'Log',
	'Class:WorkOrder/Attribute:log+' => '',
	'Class:WorkOrder/Stimulus:ev_close' => 'Uzavřít',
	'Class:WorkOrder/Stimulus:ev_close+' => '',
));


// Fieldset translation
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Ticket:baseinfo' => 'Obecné informace',
	'Ticket:date' => 'Data',
	'Ticket:contact' => 'Kontakty',
	'Ticket:moreinfo' => 'Více informací',
	'Ticket:relation' => 'Vztahy',
	'Ticket:log' => 'Komunikace',
	'Ticket:Type' => 'Kvalifikace',
	'Ticket:support' => 'Podpora',
	'Ticket:resolution' => 'Řešení',
	'Ticket:SLA' => 'SLA zpráva',
	'WorkOrder:Details' => 'Detaily',
	'WorkOrder:Moreinfo' => 'Více informací',
	'Tickets:ResolvedFrom' => 'Vyřešeno automaticky na základě %1$s',
	'Class:cmdbAbstractObject/Method:Set' => 'Nastavit',
	'Class:cmdbAbstractObject/Method:Set+' => 'Nastavení pole s pevnou hodnotou',
	'Class:cmdbAbstractObject/Method:Set/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:Set/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:Set/Param:2' => 'Hodnota',
	'Class:cmdbAbstractObject/Method:Set/Param:2+' => 'Hodnota, která se nastaví',
	'Class:cmdbAbstractObject/Method:SetCurrentDate' => 'Nastavení aktuálního data',
	'Class:cmdbAbstractObject/Method:SetCurrentDate+' => 'Nastavení pole s aktuálním datem a časem',
	'Class:cmdbAbstractObject/Method:SetCurrentDate/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetCurrentDate/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull' => 'Nastavení aktuálního data, pokud je nulové',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull+' => 'Nastaví aktuální datum a čas v prázdném poli',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:SetCurrentUser' => 'Nastavit aktuálního uživatele',
	'Class:cmdbAbstractObject/Method:SetCurrentUser+' => 'Nastaví do pole aktuálně přihlášeného uživatele',
	'Class:cmdbAbstractObject/Method:SetCurrentUser/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetCurrentUser/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit. Pokud je pole řetězec, použije se friendly name, jinak se použije identifikátor. Friendly name je jméno osoby, pokud je k uživateli připojena, jinak je to přihlašovací jméno.',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson' => 'Nastavit aktuální osobu',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson+' => 'Nastaví do pole aktuálně přihlášenou osobu („osoba“ připojená k přihlášenému „uživateli“)..',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit. Pokud je pole řetězec, použije se friendly name, jinak se použije identifikátor.',
	'Class:cmdbAbstractObject/Method:SetElapsedTime' => 'Nastavení uplynulého času',
	'Class:cmdbAbstractObject/Method:SetElapsedTime+' => 'Nastaví pole s časem (v sekundách), který uplynul od data zadaného jiným polem.',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:2' => 'Referenční pole',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:2+' => 'Pole, ze kterého se získá referenční datum',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:3' => 'Pracovní hodiny',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:3+' => 'Nechte prázdné, pokud se chcete spolehnout na standardní schéma pracovní doby, nebo nastavte hodnotu "DefaultWorkingTimeComputer", aby bylo vynuceno schéma 24x7.',
	'Class:cmdbAbstractObject/Method:SetIfNull' => 'Nastavit nulové pole',
	'Class:cmdbAbstractObject/Method:SetIfNull+' => 'Nastaví pole pevnou hodnotou, pokud je prázdné',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:2' => 'Hodnota',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:2+' => 'Hodnota, která se má nastavit',
	'Class:cmdbAbstractObject/Method:AddValue' => 'Přidat hodnotu',
	'Class:cmdbAbstractObject/Method:AddValue+' => 'Přidání pevné hodnoty do pole',
	'Class:cmdbAbstractObject/Method:AddValue/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:AddValue/Param:1+' => 'Pole, které má být v aktuálním objektu upraveno',
	'Class:cmdbAbstractObject/Method:AddValue/Param:2' => 'Hodnota',
	'Class:cmdbAbstractObject/Method:AddValue/Param:2+' => 'Desetinná hodnota, která bude přičtena, může být záporná',
	'Class:cmdbAbstractObject/Method:SetComputedDate' => 'Nastavení vypočteného data',
	'Class:cmdbAbstractObject/Method:SetComputedDate+' => 'Nastaví pole s datem vypočteným z jiného pole s dodatečnou logikou',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:2' => 'Modifikátor',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:2+' => 'Textové informace pro úpravu zdrojového data, např. "+3 dny"',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:3' => 'Zdrojové pole',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:3+' => 'Pole použité jako zdroj pro použití logiky modifikátoru',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull' => 'Nastavení vypočteného data, pokud je nulové',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull+' => 'Nastaví neprázdné pole s datem vypočteným z jiného pole s dodatečnou logikou',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:2' => 'Modifikátor',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:2+' => 'Textové informace pro úpravu zdrojového data, např. "+3 dny"',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:3' => 'Zdrojové pole',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:3+' => 'Pole použité jako zdroj pro použití logiky modifikátoru',
	'Class:cmdbAbstractObject/Method:Reset' => 'Reset',
	'Class:cmdbAbstractObject/Method:Reset+' => 'Obnovení výchozí hodnoty pole',
	'Class:cmdbAbstractObject/Method:Reset/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:Reset/Param:1+' => 'Pole aktuálního objektu, které má být resetováno',
	'Class:cmdbAbstractObject/Method:Copy' => 'Kopie',
	'Class:cmdbAbstractObject/Method:Copy+' => 'Kopírování hodnoty pole do jiného pole',
	'Class:cmdbAbstractObject/Method:Copy/Param:1' => 'Cílové pole',
	'Class:cmdbAbstractObject/Method:Copy/Param:1+' => 'Pole, které sem má v aktuálním objektu nastavit',
	'Class:cmdbAbstractObject/Method:Copy/Param:2' => 'Zdrojové pole',
	'Class:cmdbAbstractObject/Method:Copy/Param:2+' => 'Pole aktuální objektu, ze kterého má být hodnota získána',
	'Class:cmdbAbstractObject/Method:ApplyStimulus' => 'Použít stimul',
	'Class:cmdbAbstractObject/Method:ApplyStimulus+' => 'Použít zadaný stimul na aktuální objekt',
	'Class:cmdbAbstractObject/Method:ApplyStimulus/Param:1' => 'Kód stimulu',
	'Class:cmdbAbstractObject/Method:ApplyStimulus/Param:1+' => 'Platný kód stimulu pro aktuální třídu',
	'Class:ResponseTicketTTO/Interface:iMetricComputer' => 'Čas pro převzetí (TTO)',
	'Class:ResponseTicketTTO/Interface:iMetricComputer+' => 'Cíl úrovně služeb typu TTO',
	'Class:ResponseTicketTTR/Interface:iMetricComputer' => 'Čas pro vyřešení (TTR)',
	'Class:ResponseTicketTTR/Interface:iMetricComputer+' => 'Cíl úrovně služeb typu TTR',
));


//
// Class: Ticket
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:Ticket/Attribute:team_email' => 'Team email~~',
	'Class:Ticket/Attribute:team_email+' => '~~',
));
